/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.mojang.datafixers.util.Either;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jblas.DoubleMatrix;
import org.jetbrains.annotations.Nullable;
import ram.talia.moreiotas.api.casting.iota.EntityTypeIota;
import ram.talia.moreiotas.api.casting.iota.IotaTypeIota;
import ram.talia.moreiotas.api.casting.iota.ItemTypeIota;
import ram.talia.moreiotas.api.casting.iota.MatrixIota;
import ram.talia.moreiotas.api.casting.iota.StringIota;

public class MoreIotasIotaLuaUtils {
    @Nullable
    public static Iota getMoreIotasIota(Object luaObject) {
        String string;
        if (luaObject instanceof String && (string = (String)luaObject) != null) {
            try {
                return StringIota.make((String)string);
            }
            catch (MishapInvalidIota e) {
                DuckyPeriphs.logPrint("Invalid string iota (too long): " + string);
                return new GarbageIota();
            }
        }
        if (luaObject instanceof Map) {
            Map table = (Map)luaObject;
            if (table.containsKey("iotaType") && table.get("iotaType") instanceof String) {
                String typeKey = (String)table.get("iotaType");
                if (!ResourceLocation.m_135830_((String)typeKey)) {
                    return new GarbageIota();
                }
                ResourceLocation typeLoc = new ResourceLocation(typeKey);
                IotaType type = (IotaType)HexIotaTypes.REGISTRY.m_7745_(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new IotaTypeIota(type);
            }
            if (table.containsKey("entityType") && table.get("entityType") instanceof String) {
                String typeKey = (String)table.get("entityType");
                if (!ResourceLocation.m_135830_((String)typeKey)) {
                    return new GarbageIota();
                }
                ResourceLocation typeLoc = new ResourceLocation(typeKey);
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new EntityTypeIota(type);
            }
            if (table.containsKey("itemType") && table.get("itemType") instanceof String && table.containsKey("isItem") && table.get("isItem") instanceof Boolean) {
                String typeKey = (String)table.get("itemType");
                Boolean isItem = (Boolean)table.get("isItem");
                if (!ResourceLocation.m_135830_((String)typeKey)) {
                    return new GarbageIota();
                }
                ResourceLocation typeLoc = new ResourceLocation(typeKey);
                if (isItem.booleanValue()) {
                    Item type = (Item)BuiltInRegistries.f_257033_.m_7745_(typeLoc);
                    if (type == null) {
                        return new GarbageIota();
                    }
                    return new ItemTypeIota(type);
                }
                Block type = (Block)BuiltInRegistries.f_256975_.m_7745_(typeLoc);
                if (type == null) {
                    return new GarbageIota();
                }
                return new ItemTypeIota(type);
            }
            if (table.containsKey("col") && table.get("col") instanceof Number && table.containsKey("row") && table.get("row") instanceof Number && table.containsKey("matrix") && table.get("matrix") instanceof Map) {
                int col = ((Number)table.get("col")).intValue();
                int row = ((Number)table.get("row")).intValue();
                DoubleMatrix matrix = new DoubleMatrix(row, col);
                Map matrixTable = (Map)table.get("matrix");
                for (int i = 1; i <= col * row; ++i) {
                    if (!matrixTable.containsKey(i) || !(matrixTable.get(i) instanceof Number)) continue;
                    matrix.put(i - 1, ((Number)matrixTable.get(i)).doubleValue());
                }
                try {
                    return new MatrixIota(matrix);
                }
                catch (MishapInvalidIota e) {
                    DuckyPeriphs.logPrint("Invalid matrix iota (too big?): " + matrix);
                    return new GarbageIota();
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Object getMoreIotasObject(Iota iota) {
        if (iota instanceof IotaTypeIota) {
            IotaType type = ((IotaTypeIota)iota).getIotaType();
            HashMap<String, String> typeTable = new HashMap<String, String>();
            Optional typeLoc = HexIotaTypes.REGISTRY.m_7854_((Object)type);
            if (!typeLoc.isPresent()) {
                return null;
            }
            typeTable.put("iotaType", ((ResourceKey)typeLoc.get()).m_135782_().toString());
            return typeTable;
        }
        if (iota instanceof EntityTypeIota) {
            EntityType type = ((EntityTypeIota)iota).getEntityType();
            HashMap<String, String> typeTable = new HashMap<String, String>();
            Optional typeLoc = BuiltInRegistries.f_256780_.m_7854_((Object)type);
            if (!typeLoc.isPresent()) {
                return null;
            }
            typeTable.put("entityType", ((ResourceKey)typeLoc.get()).m_135782_().toString());
            return typeTable;
        }
        if (iota instanceof ItemTypeIota) {
            Either type = ((ItemTypeIota)iota).getEither();
            HashMap<String, Object> typeTable = new HashMap<String, Object>();
            Optional item = type.left();
            if (item.isPresent()) {
                Optional typeLoc = BuiltInRegistries.f_257033_.m_7854_((Object)((Item)item.get()));
                if (!typeLoc.isPresent()) return null;
                typeTable.put("itemType", ((ResourceKey)typeLoc.get()).m_135782_().toString());
                typeTable.put("isItem", true);
                return typeTable;
            } else {
                Optional block = type.right();
                if (!block.isPresent()) return null;
                Optional typeLoc = BuiltInRegistries.f_256975_.m_7854_((Object)((Block)block.get()));
                if (!typeLoc.isPresent()) return null;
                typeTable.put("itemType", ((ResourceKey)typeLoc.get()).m_135782_().toString());
                typeTable.put("isItem", false);
            }
            return typeTable;
        }
        if (iota instanceof StringIota) {
            return ((StringIota)iota).getString();
        }
        if (!(iota instanceof MatrixIota)) return null;
        DoubleMatrix matrix = ((MatrixIota)iota).getMatrix();
        HashMap<String, Serializable> matrixTable = new HashMap<String, Serializable>();
        matrixTable.put("col", Integer.valueOf(matrix.columns));
        matrixTable.put("row", Integer.valueOf(matrix.rows));
        HashMap<Double, Double> matrixData = new HashMap<Double, Double>();
        for (int i = 1; i <= matrix.columns * matrix.rows; ++i) {
            matrixData.put(Double.valueOf(i), matrix.get(i - 1));
        }
        matrixTable.put("matrix", matrixData);
        return matrixTable;
    }
}

