/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Either;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import ram.talia.hexal.api.casting.iota.GateIota;

public class HexalObfMapState
extends SavedData {
    private BiMap<UUID, Integer> gateMap = HashBiMap.create();
    private BiMap<UUID, GateData> typedGateMap = HashBiMap.create();
    private BiMap<UUID, MoteData> moteMap = HashBiMap.create();

    @Nullable
    public Integer getGateInt(UUID uuid) {
        return (Integer)this.gateMap.get((Object)uuid);
    }

    @Nullable
    public GateData getGateData(UUID uuid) {
        return (GateData)this.typedGateMap.get((Object)uuid);
    }

    @Nullable
    public UUID getGateUUID(int gateInt) {
        return (UUID)this.gateMap.inverse().get((Object)gateInt);
    }

    public UUID getOrCreateGateUUID(GateData gData) {
        UUID uuid = this.getGateUUID(gData.index());
        if (uuid == null) {
            uuid = this.newGate(gData);
        }
        return uuid;
    }

    private void addGateToMap(UUID uuid, GateData gData) {
        this.gateMap.put((Object)uuid, (Object)gData.index());
        this.typedGateMap.put((Object)uuid, (Object)gData);
        this.m_77762_();
    }

    public UUID newGate(GateData gData) {
        UUID uuid = UUID.randomUUID();
        while (this.gateMap.containsKey((Object)uuid) || this.typedGateMap.containsKey((Object)uuid)) {
            uuid = UUID.randomUUID();
        }
        this.addGateToMap(uuid, gData);
        return uuid;
    }

    @Nullable
    public MoteData getMoteData(UUID uuid) {
        return (MoteData)this.moteMap.get((Object)uuid);
    }

    @Nullable
    public UUID getMoteObfUUID(MoteData moteData) {
        return (UUID)this.moteMap.inverse().get((Object)moteData);
    }

    public UUID getOrCreateMoteObfUUID(MoteData moteData) {
        UUID uuid = this.getMoteObfUUID(moteData);
        if (uuid == null) {
            uuid = this.newMote(moteData);
        }
        return uuid;
    }

    private void addMoteToMap(UUID uuid, MoteData moteData) {
        this.moteMap.put((Object)uuid, (Object)moteData);
        this.m_77762_();
    }

    public UUID newMote(MoteData moteData) {
        UUID uuid = UUID.randomUUID();
        while (this.moteMap.containsKey((Object)uuid)) {
            uuid = UUID.randomUUID();
        }
        this.addMoteToMap(uuid, moteData);
        return uuid;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag gateMapNbt = new CompoundTag();
        for (UUID uuid : this.typedGateMap.keySet()) {
            CompoundTag gateDataNbt = ((GateData)this.typedGateMap.get((Object)uuid)).toNbt();
            gateMapNbt.m_128365_(uuid.toString(), (Tag)gateDataNbt);
        }
        nbt.m_128365_("hexalTypedGateMap", (Tag)gateMapNbt);
        CompoundTag moteMapNbt = new CompoundTag();
        for (UUID uuid : this.moteMap.keySet()) {
            MoteData moteData = (MoteData)this.moteMap.get((Object)uuid);
            CompoundTag moteDataNbt = new CompoundTag();
            moteDataNbt.m_128362_("storageUuid", moteData.uuid);
            moteDataNbt.m_128405_("index", moteData.index);
            moteDataNbt.m_128359_("itemID", moteData.itemID);
            moteMapNbt.m_128365_(uuid.toString(), (Tag)moteDataNbt);
        }
        nbt.m_128365_("hexalMoteMap", (Tag)moteMapNbt);
        return nbt;
    }

    public static HexalObfMapState createFromNbt(CompoundTag tag) {
        HexalObfMapState serverState = new HexalObfMapState();
        CompoundTag typedGateMapNbt = tag.m_128469_("hexalTypedGateMap");
        if (typedGateMapNbt == null || typedGateMapNbt.m_128456_()) {
            CompoundTag gateMapNbt = tag.m_128469_("hexalGateMap");
            for (String uuidString : gateMapNbt.m_128431_()) {
                GateData simpleData = new GateData(gateMapNbt.m_128451_(uuidString), 0, null, null);
                serverState.addGateToMap(UUID.fromString(uuidString), simpleData);
            }
        } else {
            for (String uuidString : typedGateMapNbt.m_128431_()) {
                GateData gData = GateData.fromNbt(typedGateMapNbt.m_128469_(uuidString));
                serverState.addGateToMap(UUID.fromString(uuidString), gData);
            }
        }
        CompoundTag moteMapNbt = tag.m_128469_("hexalMoteMap");
        for (String uuidString : moteMapNbt.m_128431_()) {
            CompoundTag moteDataNbt = moteMapNbt.m_128469_(uuidString);
            MoteData moteData = new MoteData(moteDataNbt.m_128342_("storageUuid"), moteDataNbt.m_128451_("index"), moteDataNbt.m_128461_("itemID"));
            serverState.addMoteToMap(UUID.fromString(uuidString), moteData);
        }
        return serverState;
    }

    public static HexalObfMapState getServerState(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.m_129880_(Level.f_46428_).m_8895_();
        HexalObfMapState serverState = (HexalObfMapState)persistentStateManager.m_164861_(HexalObfMapState::createFromNbt, HexalObfMapState::new, "ducky-periphs:hexal_gate_map");
        serverState.m_77762_();
        return serverState;
    }

    public static GateData GateDataFromIota(GateIota iota) {
        Either target = iota.getTarget();
        if (iota.isDrifting() || target == null) {
            return new GateData(iota.getGateIndex(), 0, null, null);
        }
        if (target.left().isPresent()) {
            return new GateData(iota.getGateIndex(), 1, (Vec3)target.left().get(), null);
        }
        if (target.right().isPresent()) {
            GateIota.EntityAnchor anchor = (GateIota.EntityAnchor)target.right().get();
            return new GateData(iota.getGateIndex(), 2, anchor.offset(), anchor.uuid());
        }
        return new GateData(iota.getGateIndex(), 0, null, null);
    }

    public record GateData(int index, int type, Vec3 tVec, UUID entUuid) {
        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("index", this.index);
            nbt.m_128405_("type", this.type);
            if (this.type == 1 || this.type == 2) {
                nbt.m_128347_("tVecX", this.tVec.f_82479_);
                nbt.m_128347_("tVecY", this.tVec.f_82480_);
                nbt.m_128347_("tVecZ", this.tVec.f_82481_);
            }
            if (this.type == 2) {
                nbt.m_128362_("entUuid", this.entUuid);
            }
            return nbt;
        }

        public static GateData fromNbt(CompoundTag nbt) {
            int index = nbt.m_128451_("index");
            int type = nbt.m_128451_("type");
            Vec3 tVec = null;
            UUID entUuid = null;
            if (type == 1 || type == 2) {
                tVec = new Vec3(nbt.m_128459_("tVecX"), nbt.m_128459_("tVecY"), nbt.m_128459_("tVecZ"));
            }
            if (type == 2) {
                entUuid = nbt.m_128342_("entUuid");
            }
            return new GateData(index, type, tVec, entUuid);
        }
    }

    public record MoteData(UUID uuid, int index, String itemID) {
    }
}

