/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import com.mojang.datafixers.util.Either;
import com.samsthenerd.duckyperiphs.hexcasting.utils.HexalObfMapState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.server.level.ServerLevel;
import ram.talia.hexal.api.casting.iota.GateIota;
import ram.talia.hexal.api.casting.iota.MoteIota;
import ram.talia.hexal.api.mediafieditems.MediafiedItemManager;

public class HexalIotaLuaUtils {
    public static Iota getHexalIota(Object luaObject, ServerLevel world) {
        if (luaObject instanceof Map) {
            Map table = (Map)luaObject;
            if (table.containsKey("gate") && table.get("gate") instanceof String) {
                UUID gateUUID;
                HexalObfMapState gateMap;
                HexalObfMapState.GateData gData;
                if (world != null && (gData = (gateMap = HexalObfMapState.getServerState(world.m_7654_())).getGateData(gateUUID = UUID.fromString((String)table.get("gate")))) != null) {
                    if (gData.type() == 0) {
                        return new GateIota(gData.index(), null);
                    }
                    if (gData.type() == 1) {
                        return new GateIota(gData.index(), Either.left((Object)gData.tVec()));
                    }
                    if (gData.type() == 2) {
                        Pair gatePair = new Pair((Object)world.m_8791_(gData.entUuid()), (Object)gData.tVec());
                        return new GateIota(gData.index(), Either.right((Object)gatePair));
                    }
                }
                return new NullIota();
            }
            if (table.containsKey("moteUuid") && table.get("moteUuid") instanceof String && table.containsKey("itemID") && table.get("itemID") instanceof String) {
                UUID moteUUID = UUID.fromString((String)table.get("moteUuid"));
                String itemID = (String)table.get("itemID");
                HexalObfMapState.MoteData moteData = HexalObfMapState.getServerState(world.m_7654_()).getMoteData(moteUUID);
                if (moteData == null || !itemID.equals(moteData.itemID())) {
                    return new GarbageIota();
                }
                UUID storageUUID = moteData.uuid();
                Integer index = moteData.index();
                MediafiedItemManager manager = MediafiedItemManager.INSTANCE;
                if (manager != null) {
                    MediafiedItemManager.Index mediafiedIndex = new MediafiedItemManager.Index(storageUUID, index.intValue());
                    return new MoteIota(mediafiedIndex);
                }
                return new NullIota();
            }
        }
        return null;
    }

    public static Object getHexalObject(Iota iota, ServerLevel world) {
        if (iota instanceof GateIota) {
            if (world != null) {
                GateIota gateIota = (GateIota)iota;
                HexalObfMapState.GateData gData = HexalObfMapState.GateDataFromIota(gateIota);
                UUID thisGateUUID = HexalObfMapState.getServerState(world.m_7654_()).getOrCreateGateUUID(gData);
                HashMap<String, Object> gateTable = new HashMap<String, Object>();
                gateTable.put("gate", thisGateUUID.toString());
                if (gData.type() == 0) {
                    gateTable.put("gateType", "drifting");
                } else {
                    HashMap<String, Double> locationTable = new HashMap<String, Double>();
                    locationTable.put("x", gData.tVec().f_82479_);
                    locationTable.put("y", gData.tVec().f_82480_);
                    locationTable.put("z", gData.tVec().f_82481_);
                    if (gData.type() == 1) {
                        gateTable.put("gateType", "location");
                        gateTable.put("location", locationTable);
                    } else if (gData.type() == 2) {
                        gateTable.put("gateType", "entity");
                        gateTable.put("entity", gData.entUuid().toString());
                        gateTable.put("offset", locationTable);
                    }
                }
                return gateTable;
            }
            return null;
        }
        if (iota instanceof MoteIota) {
            MediafiedItemManager.Index itemIndex = ((MoteIota)iota).getItemIndex();
            if (itemIndex == null) {
                return null;
            }
            UUID uuid = itemIndex.getStorage();
            int index = itemIndex.getIndex();
            String itemID = ((MoteIota)iota).getItem().toString();
            HexalObfMapState.MoteData moteData = new HexalObfMapState.MoteData(uuid, index, itemID);
            UUID thisMoteUUID = HexalObfMapState.getServerState(world.m_7654_()).getOrCreateMoteObfUUID(moteData);
            HashMap<String, String> itemTable = new HashMap<String, String>();
            itemTable.put("moteUuid", thisMoteUUID.toString());
            itemTable.put("itemID", itemID);
            itemTable.put("nexusUuid", uuid.toString());
            return itemTable;
        }
        return null;
    }
}

