/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityLookingImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityRedstoneImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockEntityRightClickImpetus;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ImpetusPeripheral
implements IPeripheral {
    private BlockEntityAbstractImpetus impetus;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    public ImpetusPeripheral(BlockEntityAbstractImpetus _impetus) {
        this.impetus = _impetus;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        if (this.impetus instanceof BlockEntityLookingImpetus) {
            return "fletcher_impetus";
        }
        if (this.impetus instanceof BlockEntityRedstoneImpetus) {
            return "cleric_impetus";
        }
        if (this.impetus instanceof BlockEntityRightClickImpetus) {
            return "toolsmith_impetus";
        }
        return "impetus";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final MethodResult getMedia() {
        return MethodResult.of((Object)this.impetus.getMedia());
    }

    @LuaFunction
    public final MethodResult getRemainingMediaCapacity() {
        return MethodResult.of((Object)this.impetus.remainingMediaCapacity());
    }

    @LuaFunction
    public final MethodResult getLastMishap() {
        Component mishap = this.impetus.getDisplayMsg();
        if (mishap == null) {
            return MethodResult.of((Object)"");
        }
        return MethodResult.of((Object)mishap.getString());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCaster() {
        UUID casterUUID = null;
        Level level = this.impetus.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            CircleExecutionState state = this.impetus.getExecutionState();
            if (state != null && state.getCaster(sWorld) != null) {
                casterUUID = state.getCaster(sWorld).m_20148_();
            } else {
                BlockEntityAbstractImpetus blockEntityAbstractImpetus = this.impetus;
                if (blockEntityAbstractImpetus instanceof BlockEntityRedstoneImpetus) {
                    BlockEntityRedstoneImpetus rsImpetus = (BlockEntityRedstoneImpetus)blockEntityAbstractImpetus;
                    casterUUID = rsImpetus.getStoredPlayer().m_20148_();
                }
            }
        }
        if (casterUUID == null) {
            return MethodResult.of((Object)"");
        }
        return MethodResult.of((Object)casterUUID.toString());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isCasting() {
        BlockPos pos;
        ServerLevel sWorld;
        BlockState state;
        Block block;
        Level level = this.impetus.m_58904_();
        if (level instanceof ServerLevel && (block = (state = (sWorld = (ServerLevel)level).m_8055_(pos = this.impetus.m_58899_())).m_60734_()) instanceof ICircleComponent) {
            ICircleComponent comp = (ICircleComponent)block;
            return MethodResult.of((Object)comp.isEnergized(pos, state, (Level)sWorld));
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult activateCircle() {
        BlockEntityAbstractImpetus blockEntityAbstractImpetus = this.impetus;
        if (blockEntityAbstractImpetus instanceof BlockEntityRedstoneImpetus) {
            BlockEntityRedstoneImpetus rsImpetus = (BlockEntityRedstoneImpetus)blockEntityAbstractImpetus;
            rsImpetus.startExecution(rsImpetus.getStoredPlayer());
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    public void impetusStarted() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("circle_activated", new Object[]{computer.getAttachmentName()});
        }
    }

    public void impetusEnded() {
        Component mishap = this.impetus.getDisplayMsg();
        String mishapString = "";
        if (mishap != null) {
            mishapString = mishap.getString();
        }
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("circle_stopped", new Object[]{mishapString, computer.getAttachmentName()});
        }
    }
}

