/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.misc.TriPredicate;
import at.petrak.hexcasting.common.blocks.akashic.AkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals.AkashicBookshelfPeripheral;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AkashicRecordPeripheral
implements IPeripheral {
    private BlockPos recordPos;
    private Level recordWorld;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    AkashicRecordPeripheral(BlockPos _pos, Level world) {
        this.recordPos = _pos;
        this.recordWorld = world;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "akashic_record";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult readRecord() {
        FloodfillLogger sneakyPredicate = new FloodfillLogger();
        AkashicFloodfiller.floodFillFor((BlockPos)this.recordPos, (Level)this.recordWorld, (float)0.0f, (TriPredicate)sneakyPredicate, (int)128);
        return MethodResult.of(sneakyPredicate.getRecordTable());
    }

    private class FloodfillLogger
    implements TriPredicate<BlockPos, BlockState, Level> {
        private Map<String, Object> recordTable = new HashMap<String, Object>();

        private FloodfillLogger() {
        }

        public boolean test(BlockPos pos, BlockState state, Level world) {
            BlockEntity be = world.m_7702_(pos);
            if (be == null) {
                return false;
            }
            if (be instanceof BlockEntityAkashicBookshelf) {
                BlockEntityAkashicBookshelf shelf = (BlockEntityAkashicBookshelf)be;
                HexPattern pattern = shelf.getPattern();
                if (pattern == null) {
                    return false;
                }
                String angleSig = pattern.anglesSignature();
                if (!this.recordTable.containsKey(angleSig)) {
                    this.recordTable.put(angleSig, AkashicBookshelfPeripheral.shelfData(shelf));
                }
            }
            return false;
        }

        public Map<String, Object> getRecordTable() {
            return this.recordTable;
        }
    }
}

