/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.hexcasting.utils.IotaLuaUtils;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class AkashicBookshelfPeripheral
implements IPeripheral {
    private BlockEntityAkashicBookshelf bookshelf;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    AkashicBookshelfPeripheral(BlockEntityAkashicBookshelf _bookshelf) {
        this.bookshelf = _bookshelf;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "akashic_bookshelf";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final MethodResult readShelf() {
        return MethodResult.of(AkashicBookshelfPeripheral.shelfData(this.bookshelf));
    }

    public static Map<String, Object> shelfData(BlockEntityAkashicBookshelf bookshelf) {
        Object iotaObject;
        CompoundTag tag = bookshelf.getIotaTag();
        Level world = bookshelf.m_58904_();
        NullIota iota = new NullIota();
        if (world instanceof ServerLevel) {
            ServerLevel sworld = (ServerLevel)world;
            iotaObject = IotaLuaUtils.getLuaObject(tag, sworld);
            if (tag != null) {
                iota = IotaType.deserialize((CompoundTag)tag, (ServerLevel)sworld);
            }
        } else {
            DuckyPeriphs.logPrint("reading iota in client world");
            iotaObject = IotaLuaUtils.getLuaObject(tag, null);
        }
        HashMap<String, Object> returnTable = new HashMap<String, Object>();
        returnTable.put("patternKey", IotaLuaUtils.getLuaObject(bookshelf.getPattern()));
        returnTable.put("shelfIota", iotaObject);
        returnTable.put("shelfIotaType", IotaLuaUtils.getIotaTypeID(iota.getType()));
        return returnTable;
    }
}

