/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.hexal;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexItems;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.DuckyHexal;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.FocalLinkPeripheral;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.ItemRGBColorizer;
import com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.linkable.ClientLinkableHolder;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.linkable.ServerLinkableHolder;

public class FocalLinkBlockEntity
extends BlockEntity
implements IPeripheralTileDucky,
ILinkable,
ILinkable.IRenderCentre {
    private FocalLinkPeripheral flPeriph = null;
    private static final double MAX_SQR_LINK_RANGE = 1024.0;
    private FrozenPigment colorizer = new FrozenPigment(new ItemStack((ItemLike)HexItems.DYE_PIGMENTS.get(DyeColor.PURPLE)), Util.f_137441_);
    private long colorizerTime = 0L;
    @NotNull
    public static final String TAG_COLOURISER = "hexal:colouriser";
    private RandomSource random = RandomSource.m_216327_();
    private ServerLinkableHolder linkableHolder;
    @Nullable
    private CompoundTag serialisedLinkableHolder;
    private ClientLinkableHolder clientLinkableHolder;

    public FocalLinkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DuckyHexal.FOCAL_LINK_BLOCK_ENTITY.get(), pos, state);
        this.flPeriph = new FocalLinkPeripheral(this);
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull Direction side) {
        return this.flPeriph;
    }

    protected void saveModData(CompoundTag tag) {
        ServerLinkableHolder holder = this.getLinkableHolder();
        if (holder != null) {
            NBTHelper.putCompound((CompoundTag)tag, (String)"hexal:linkable_holder", (CompoundTag)holder.writeToNbt());
        }
        NBTHelper.putCompound((CompoundTag)tag, (String)TAG_COLOURISER, (CompoundTag)this.colorizer.serializeToNBT());
    }

    protected void loadModData(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("hexal:linkable_holder")) {
            this.serialisedLinkableHolder = tag.m_128469_("hexal:linkable_holder");
        }
        if (tag.m_128441_(TAG_COLOURISER)) {
            FrozenPigment newColorizer = FrozenPigment.fromNBT((CompoundTag)tag.m_128469_(TAG_COLOURISER));
            this.setColorizer(newColorizer);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        this.saveModData(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadModData(pTag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveModData(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.m_5776_() && this.f_58857_ instanceof ServerLevel) {
                ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
            }
            super.m_6596_();
        }
    }

    @NotNull
    public UUID owner() {
        return new UUID(0L, this.f_58858_.m_121878_());
    }

    public long currentMediaLevel() {
        return 0L;
    }

    public void link(@NotNull ILinkable other, boolean linkOther) {
        ServerLinkableHolder holder = this.getLinkableHolder();
        if (holder != null && other != null) {
            holder.link(other, linkOther);
        }
    }

    public void unlink(@NotNull ILinkable other, boolean linkOther) {
        ILinkable.DefaultImpls.unlink((ILinkable)this, (ILinkable)other, (boolean)linkOther);
        this.m_6596_();
    }

    public void unlink(int index) {
        ILinkable other = this.getLinked(index);
        if (other != null) {
            this.unlink(other, true);
        }
    }

    public ILinkable getLinked(int index) {
        ServerLinkableHolder holder = this.getLinkableHolder();
        if (holder != null) {
            return holder.getLinked(index);
        }
        DuckyPeriphs.logPrint("null linkable holder");
        return null;
    }

    public int getLinkedIndex(@NotNull ILinkable other) {
        return ILinkable.DefaultImpls.getLinkedIndex((ILinkable)this, (ILinkable)other);
    }

    public int numLinked() {
        ServerLinkableHolder holder = this.getLinkableHolder();
        if (holder != null) {
            return holder.numLinked();
        }
        return -3;
    }

    public void sendIota(int index, @NotNull Iota iota) {
        ILinkable other = this.getLinked(index);
        HexalAPI.LOGGER.debug("sending {} to {}", (Object)iota, (Object)other);
        if (other != null) {
            other.receiveIota((ILinkable)this, iota);
        }
    }

    public void checkLinks() {
        ServerLinkableHolder holder = this.getLinkableHolder();
        if (holder != null) {
            holder.checkLinks();
        }
    }

    public void receiveIota(@NotNull ILinkable other, @NotNull Iota iota) {
        ILinkable.DefaultImpls.receiveIota((ILinkable)this, (ILinkable)other, (Iota)iota);
        if (!this.f_58857_.f_46443_) {
            this.flPeriph.receivedIota();
        }
    }

    public Iota nextReceivedIota() {
        return ILinkable.DefaultImpls.nextReceivedIota((ILinkable)this);
    }

    public int numRemainingIota() {
        return ILinkable.DefaultImpls.numRemainingIota((ILinkable)this);
    }

    public void clearReceivedIotas() {
        ILinkable.DefaultImpls.clearReceivedIotas((ILinkable)this);
    }

    @NotNull
    public List<Iota> allReceivedIotas() {
        return ILinkable.DefaultImpls.allReceivedIotas((ILinkable)this);
    }

    @NotNull
    public List<Component> transmittingTargetReturnDisplay() {
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent text = Component.m_237113_((String)"Focal Link ").m_130946_(this.f_58858_.m_123344_()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)Vec3Iota.TYPE.color())));
        list.add((Component)text);
        return list;
    }

    public Tag toTag() {
        return LongTag.m_128882_((long)this.f_58858_.m_121878_());
    }

    public List<Iota> getAsActionResult() {
        ArrayList<Iota> list = new ArrayList<Iota>();
        list.add((Iota)new Vec3Iota(this.getPosition()));
        return list;
    }

    @Nullable
    public ServerLinkableHolder getLinkableHolder() {
        ServerLinkableHolder tempLinkableHolder = this.linkableHolder;
        if (tempLinkableHolder == null && (this.f_58857_ instanceof ServerLevel ? (ServerLevel)this.f_58857_ : null) != null) {
            tempLinkableHolder = new ServerLinkableHolder((ILinkable)this, (ServerLevel)this.f_58857_);
            if (this.serialisedLinkableHolder != null) {
                tempLinkableHolder.readFromNbt(this.serialisedLinkableHolder);
                this.serialisedLinkableHolder = null;
            }
        }
        this.linkableHolder = tempLinkableHolder;
        if (tempLinkableHolder == null) {
            DuckyPeriphs.logPrint("linkable holder is null");
        }
        return tempLinkableHolder;
    }

    public LinkableRegistry.LinkableType<?, ?> getLinkableType() {
        return DuckyHexal.FOCAL_LINKABLE_TYPE;
    }

    public double maxSqrLinkRange() {
        return 1024.0;
    }

    public boolean shouldRemove() {
        return this.f_58859_;
    }

    public long canAcceptMedia(@NotNull ILinkable other, long otherMediaLevel) {
        return 0L;
    }

    public void acceptMedia(@NotNull ILinkable other, long otherMediaLevel) {
    }

    public Vec3 getPosition() {
        return Vec3.m_82528_((Vec3i)this.m_58899_());
    }

    public boolean isInRange(@NotNull ILinkable other) {
        return this.getPosition().m_82557_(other.getPosition()) <= 2.0 * (this.maxSqrLinkRange() + other.maxSqrLinkRange());
    }

    public ClientLinkableHolder getClientLinkableHolder() {
        ClientLinkableHolder tempLinkableHolder = this.clientLinkableHolder;
        if (tempLinkableHolder == null && this.f_58857_ != null) {
            tempLinkableHolder = new ClientLinkableHolder((ILinkable.IRenderCentre)this, this.f_58857_, this.random);
        }
        this.clientLinkableHolder = tempLinkableHolder;
        return tempLinkableHolder;
    }

    public void renderLinks() {
        ClientLinkableHolder holder = this.getClientLinkableHolder();
        if (holder != null) {
            holder.renderLinks();
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FocalLinkBlockEntity fl_tile) {
        if (fl_tile == null || world == null) {
            return;
        }
        if (world.f_46443_) {
            fl_tile.renderLinks();
        } else {
            fl_tile.checkLinks();
        }
    }

    @NotNull
    public Vec3 renderCentre(@NotNull ILinkable.IRenderCentre other, boolean recursioning) {
        return Vec3.m_82512_((Vec3i)this.m_58899_());
    }

    public FrozenPigment pigment() {
        return this.colorizer;
    }

    public final void setColorizer(@NotNull FrozenPigment newColorizer) {
        this.colorizer = newColorizer;
        this.m_6596_();
    }

    public final void setRGBColorizer(int argb) {
        this.setColorizer(new FrozenPigment(((ItemRGBColorizer)((Object)DuckyHexal.ITEM_RGB_COLORIZER.get())).stackFromRGB(argb), this.owner()));
    }
}

