/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.samsthenerd.duckyperiphs.hexcasting.ConjuredDuckyBlock;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.utils.mishapJavaSkillIssues.MishapThrowerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OpPlaceDucky
implements SpellAction {
    private static final Random RANDOM = new Random();

    public int getArgc() {
        return 2;
    }

    public boolean hasCastingSound(CastingEnvironment context) {
        return true;
    }

    public boolean awardsCastingStat(CastingEnvironment context) {
        return true;
    }

    public SpellAction.Result execute(List<? extends Iota> args, CastingEnvironment context) {
        try {
            BlockPos pos = OperatorUtils.getBlockPos(args, (int)0, (int)this.getArgc());
            context.assertPosInRange(pos);
            Vec3 dirVec = OperatorUtils.getVec3(args, (int)1, (int)this.getArgc());
            Direction dir = Direction.m_122366_((double)dirVec.f_82479_, (double)0.0, (double)dirVec.f_82481_);
            if (dir == Direction.UP || dir == Direction.DOWN) {
                dir = Direction.NORTH;
            }
            if (!context.getWorld().m_7966_((Player)context.getCaster(), pos)) {
                return null;
            }
            BlockPlaceContext placeContext = new BlockPlaceContext((Level)context.getWorld(), (Player)context.getCaster(), context.getCastingHand(), ItemStack.f_41583_, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
            BlockState worldState = context.getWorld().m_8055_(pos);
            if (!worldState.m_60629_(placeContext)) {
                throw MishapBadBlock.of((BlockPos)pos, (String)"replaceable");
            }
            ArrayList<ParticleSpray> particles = new ArrayList<ParticleSpray>();
            particles.add(ParticleSpray.cloud((Vec3)Vec3.m_82512_((Vec3i)pos), (double)1.0, (int)1));
            return new SpellAction.Result((RenderedSpell)new Spell(pos, dir), 10000L, particles, 0L);
        }
        catch (Mishap e) {
            MishapThrowerWrapper.throwMishap(e);
            return null;
        }
    }

    public OperationResult operate(CastingEnvironment env, CastingImage image, SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    private class Spell
    implements RenderedSpell {
        BlockPos pos;
        Direction direction;

        public Spell(BlockPos pos, Direction direction) {
            this.pos = pos;
            this.direction = direction;
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        public void cast(CastingEnvironment context) {
            if (!context.canEditBlockAt(this.pos)) {
                return;
            }
            Block block = (Block)DuckyCasting.CONJURED_DUCKY_BLOCK.get();
            FrozenPigment colorizer = IXplatAbstractions.INSTANCE.getPigment((Player)context.getCaster());
            ItemStack duckyItemStack = new ItemStack((ItemLike)((ConjuredDuckyBlock)((Object)DuckyCasting.CONJURED_DUCKY_BLOCK.get())).m_5456_());
            BlockPlaceContext placeContext = new BlockPlaceContext((Level)context.getWorld(), (Player)context.getCaster(), context.getCastingHand(), duckyItemStack, new BlockHitResult(Vec3.m_82512_((Vec3i)this.pos), Direction.UP, this.pos, false));
            BlockState worldState = context.getWorld().m_8055_(this.pos);
            if (worldState.m_60629_(placeContext)) {
                if (!IXplatAbstractions.INSTANCE.isPlacingAllowed(context.getWorld(), this.pos, new ItemStack((ItemLike)((ConjuredDuckyBlock)((Object)DuckyCasting.CONJURED_DUCKY_BLOCK.get())).m_5456_()), (Player)context.getCaster())) {
                    return;
                }
                BlockState state = (BlockState)block.m_5573_(placeContext).m_61124_((Property)ConjuredDuckyBlock.FACING, (Comparable)this.direction);
                if (state != null) {
                    context.getWorld().m_46597_(this.pos, state);
                    if (context.getWorld().m_8055_(this.pos).m_60734_() instanceof ConjuredDuckyBlock) {
                        ConjuredDuckyBlock.setColor((LevelAccessor)context.getWorld(), this.pos, colorizer);
                    }
                }
            }
        }
    }
}

