/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting;

import at.petrak.hexcasting.api.casting.iota.Iota;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortBlockEntity;
import com.samsthenerd.duckyperiphs.hexcasting.utils.IotaLuaUtils;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class FocalPortPeripheral
implements IPeripheral {
    private final FocalPortBlockEntity fpTile;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    FocalPortPeripheral(FocalPortBlockEntity _fpTile) {
        this.fpTile = _fpTile;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "focal_port";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final MethodResult readIota() {
        Object luaObject;
        Iota iota = this.fpTile.getIota();
        Level world = this.fpTile.m_58904_();
        if (world instanceof ServerLevel) {
            ServerLevel sworld = (ServerLevel)world;
            luaObject = IotaLuaUtils.getLuaObject(iota, sworld);
        } else {
            DuckyPeriphs.logPrint("reading iota in client world");
            luaObject = IotaLuaUtils.getLuaObject(iota, null);
        }
        return MethodResult.of((Object)luaObject);
    }

    @LuaFunction
    public final MethodResult writeIota(Object luaObject) {
        if (this.fpTile.m_58904_().m_5776_() || this.fpTile.m_58904_() == null) {
            return MethodResult.of((Object)false);
        }
        Iota iota = IotaLuaUtils.getIota(luaObject, (ServerLevel)this.fpTile.m_58904_());
        return MethodResult.of((Object)this.fpTile.writeIota(iota, false));
    }

    @LuaFunction
    public final MethodResult canWriteIota(Object luaObject) {
        if (this.fpTile.m_58904_().m_5776_() || this.fpTile.m_58904_() == null) {
            return MethodResult.of((Object)false);
        }
        Iota iota = IotaLuaUtils.getIota(luaObject, (ServerLevel)this.fpTile.m_58904_());
        return MethodResult.of((Object)this.fpTile.writeIota(iota, true));
    }

    @LuaFunction
    public final MethodResult hasFocus(Object luaObject) {
        if (this.fpTile.m_58904_().m_5776_() || this.fpTile.m_58904_() == null) {
            return MethodResult.of((Object)false);
        }
        return MethodResult.of((Object)this.fpTile.hasFocus());
    }

    @LuaFunction
    public final MethodResult getIotaType() {
        if (this.fpTile.m_58904_().m_5776_() || this.fpTile.m_58904_() == null) {
            return MethodResult.of();
        }
        Iota iota = this.fpTile.getIota();
        if (iota == null) {
            return MethodResult.of((Object)"empty");
        }
        return MethodResult.of((Object)IotaLuaUtils.getIotaTypeID(iota.getType()));
    }

    @LuaFunction
    public final MethodResult getSlotCount() {
        return MethodResult.of((Object)this.fpTile.getSlotCount());
    }

    @LuaFunction
    public final MethodResult getCurrentSlot() {
        return MethodResult.of((Object)this.fpTile.getCurrentSlot());
    }

    @LuaFunction
    public final MethodResult setCurrentSlot(int slot) {
        return MethodResult.of((Object)this.fpTile.setCurrentSlot(slot));
    }

    public void updateIota() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("new_iota", new Object[]{computer.getAttachmentName()});
        }
    }

    public void attachFocus() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("focus_inserted", new Object[]{computer.getAttachmentName()});
        }
    }

    public void detachFocus() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("focus_removed", new Object[]{computer.getAttachmentName()});
        }
    }
}

