/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting;

import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.lib.HexItems;
import com.samsthenerd.duckyperiphs.compat.gloopy.GloopyUtils;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortPeripheral;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortWrapperEntity;
import com.samsthenerd.duckyperiphs.peripherals.IPeripheralTileDucky;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FocalPortBlockEntity
extends BlockEntity
implements IPeripheralTileDucky,
ADIotaHolder,
Container {
    private FocalPortPeripheral fpPeriph = new FocalPortPeripheral(this);
    private ItemStack innerFocusStack;
    private int iotaColor = NullIota.TYPE.color();
    private FocalPortWrapperEntity wrapperEntity;
    private UUID wrapperEntityUUID;

    public FocalPortBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DuckyCasting.FOCAL_PORT_BLOCK_ENTITY.get(), pos, state);
        this.innerFocusStack = ItemStack.f_41583_;
    }

    public void spawnWrapperEntity(BlockPos pos) {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (this.wrapperEntityUUID != null) {
            this.wrapperEntity = (FocalPortWrapperEntity)((ServerLevel)this.f_58857_).m_8791_(this.wrapperEntityUUID);
        }
        if (this.wrapperEntity != null) {
            return;
        }
        this.wrapperEntity = new FocalPortWrapperEntity((EntityType<? extends FocalPortWrapperEntity>)((EntityType)DuckyCasting.FOCAL_PORT_WRAPPER_ENTITY.get()), this.f_58857_);
        this.wrapperEntity = (FocalPortWrapperEntity)((EntityType)DuckyCasting.FOCAL_PORT_WRAPPER_ENTITY.get()).m_262455_((ServerLevel)this.f_58857_, null, null, pos.m_121996_(new Vec3i(0, 1, 0)), MobSpawnType.TRIGGERED, true, false);
        this.wrapperEntityUUID = this.wrapperEntity.m_20148_();
        this.m_6596_();
    }

    public void despawnWrapperEntity() {
        if (this.wrapperEntityUUID != null && this.f_58857_ instanceof ServerLevel) {
            this.wrapperEntity = (FocalPortWrapperEntity)((ServerLevel)this.f_58857_).m_8791_(this.wrapperEntityUUID);
        }
        if (this.wrapperEntity != null) {
            this.wrapperEntity.m_146870_();
            this.wrapperEntity = null;
        }
    }

    public void resetWrapperEntity() {
        if (this.wrapperEntity != null) {
            BlockPos goalPos = this.m_58899_().m_121996_(new Vec3i(0, 1, 0));
            this.wrapperEntity.m_6034_((double)goalPos.m_123341_() + 0.5, goalPos.m_123342_(), (double)goalPos.m_123343_() + 0.5);
        }
    }

    public void destroy() {
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)this);
        this.despawnWrapperEntity();
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@Nonnull Direction side) {
        if (this.fpPeriph == null) {
            this.fpPeriph = new FocalPortPeripheral(this);
        }
        return this.fpPeriph;
    }

    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    public Level m_58904_() {
        return this.f_58857_;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("wrapperEntityUUID")) {
            this.wrapperEntityUUID = nbt.m_128342_("wrapperEntityUUID");
        }
        if (nbt != null && nbt.m_128425_("innerFocusStack", 10)) {
            this.innerFocusStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("innerFocusStack"));
        }
        if (nbt != null && nbt.m_128425_("iotaColor", 3)) {
            this.setColor(nbt.m_128451_("iotaColor"));
            this.m_6596_();
            Level world = this.m_58904_();
            if (world != null) {
                // empty if block
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.wrapperEntityUUID != null) {
            nbt.m_128362_("wrapperEntityUUID", this.wrapperEntityUUID);
        }
        if (Integer.valueOf(this.iotaColor) != null) {
            nbt.m_128405_("iotaColor", this.iotaColor);
        }
        if (this.innerFocusStack != null) {
            nbt.m_128365_("innerFocusStack", (Tag)this.innerFocusStack.m_41739_(new CompoundTag()));
        }
    }

    public CompoundTag readIotaTag() {
        if (this.innerFocusStack != null && this.innerFocusStack.m_41720_() instanceof ItemFocus) {
            return ((ItemFocus)this.innerFocusStack.m_41720_()).readIotaTag(this.innerFocusStack);
        }
        if (Platform.isModLoaded((String)"hexgloop")) {
            return GloopyUtils.getIotaNbt(this.innerFocusStack);
        }
        return null;
    }

    public boolean writeIota(@Nullable Iota iota, boolean simulate, boolean fromHex) {
        boolean result = this.writeIota(iota, simulate);
        if (!simulate && result && fromHex) {
            this.fpPeriph.updateIota();
        }
        return result;
    }

    public boolean writeIota(@Nullable Iota iota, boolean simulate) {
        if (iota == null || this.innerFocusStack.m_41619_() || this.innerFocusStack.m_41720_() instanceof ItemFocus && !((ItemFocus)this.innerFocusStack.m_41720_()).canWrite(this.innerFocusStack, iota)) {
            if (Platform.isModLoaded((String)"hexgloop")) {
                if (!GloopyUtils.writeIota(this.innerFocusStack, iota, true)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!simulate) {
            if (this.innerFocusStack.m_41720_() instanceof ItemFocus) {
                ((ItemFocus)this.innerFocusStack.m_41720_()).writeDatum(this.innerFocusStack, iota);
            } else if (Platform.isModLoaded((String)"hexgloop")) {
                GloopyUtils.writeIota(this.innerFocusStack, iota, false);
            }
            if (iota == null) {
                iota = new NullIota();
            }
            this.setColor(iota.getType().color());
            this.m_6596_();
        }
        return true;
    }

    public Iota getIota() {
        CompoundTag tag;
        NullIota iota = new NullIota();
        if (!this.innerFocusStack.m_41619_() && this.m_58904_() instanceof ServerLevel && (tag = this.readIotaTag()) != null) {
            return IotaType.deserialize((CompoundTag)tag, (ServerLevel)((ServerLevel)this.m_58904_()));
        }
        this.setColor(iota.getType().color());
        return iota;
    }

    public boolean hasFocus() {
        return !this.innerFocusStack.m_41619_();
    }

    public int getSlotCount() {
        if (Platform.isModLoaded((String)"hexgloop")) {
            return GloopyUtils.pageCount(this.innerFocusStack);
        }
        return 1;
    }

    public int getCurrentSlot() {
        int gloopedSlot;
        if (Platform.isModLoaded((String)"hexgloop") && (gloopedSlot = GloopyUtils.getPage(this.innerFocusStack)) >= 1) {
            return gloopedSlot;
        }
        return 1;
    }

    public int setCurrentSlot(int slot) {
        int slotToReturn = 1;
        if (Platform.isModLoaded((String)"hexgloop")) {
            int gloopedSlot;
            slotToReturn = gloopedSlot = GloopyUtils.setPage(this.innerFocusStack, slot);
        }
        this.updateColor();
        this.m_6596_();
        return slotToReturn;
    }

    private void setColor(int color) {
        this.iotaColor = color;
        Level world = this.m_58904_();
        if (world != null && !world.f_46443_) {
            world.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void updateColor() {
        this.setColor(this.getIota().getType().color());
    }

    public int getColor() {
        if (this.innerFocusStack.m_41619_()) {
            return -8355712;
        }
        return this.iotaColor;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_5776_()) {
                Minecraft.m_91087_().f_91060_.m_109494_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
            } else if (this.f_58857_ instanceof ServerLevel) {
                ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
            }
            super.m_6596_();
        }
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.innerFocusStack.m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        if (slot == 0) {
            return this.innerFocusStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot != 0 || amount != 1) {
            return ItemStack.f_41583_;
        }
        return this.m_8016_(slot);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack result = this.innerFocusStack;
        this.innerFocusStack = ItemStack.f_41583_;
        this.fpPeriph.detachFocus();
        this.updateColor();
        this.m_6596_();
        return result;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (stack.m_41619_() || slot != 0) {
            return false;
        }
        if (stack.m_41720_() == HexItems.FOCUS) {
            return true;
        }
        return Platform.isModLoaded((String)"hexgloop") && GloopyUtils.goesInFocalPort(stack);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot != 0 || !this.m_7013_(slot, stack)) {
            return;
        }
        this.innerFocusStack = stack;
        this.fpPeriph.attachFocus();
        this.updateColor();
        this.m_6596_();
    }

    public void m_6211_() {
        this.innerFocusStack = ItemStack.f_41583_;
        this.updateColor();
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        Optional beOpt = this.f_58857_.m_141902_(this.f_58858_, (BlockEntityType)DuckyCasting.FOCAL_PORT_BLOCK_ENTITY.get());
        if (beOpt.isPresent()) {
            FocalPortBlockEntity be = (FocalPortBlockEntity)beOpt.get();
            if (be.hasFocus()) {
                ItemStack oldFocusStack = be.m_8016_(0);
                ItemStack newFocusStack = player.m_21120_(hand);
                if (this.m_7013_(0, newFocusStack)) {
                    be.m_6836_(0, newFocusStack);
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                if (!player.m_150109_().m_36054_(oldFocusStack)) {
                    player.m_36176_(oldFocusStack, false);
                }
                InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            } else {
                ItemStack focusStack = player.m_21120_(hand);
                if (!this.m_7013_(0, focusStack)) {
                    return InteractionResult.PASS;
                }
                be.m_6836_(0, focusStack);
                player.m_21008_(hand, ItemStack.f_41583_);
                InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.CONSUME;
    }
}

