/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import com.samsthenerd.duckyperiphs.hexcasting.ConjuredDuckyBER;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortBlock;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortBlockEntity;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckyCastingClient {
    public static void init() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)DuckyCasting.CONJURED_DUCKY_BLOCK_ENTITY.get()), ConjuredDuckyBER::new);
        if (Platform.isFabric()) {
            DuckyCastingClient.registerEntityRenderers();
        }
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)DuckyCasting.FOCAL_PORT_BLOCK.get(), (Block)DuckyCasting.CONJURED_DUCKY_BLOCK.get()});
        DuckyCastingClient.setupColorProviders();
        DuckyCastingClient.setupScryingDisplayers();
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(DuckyCasting.FOCAL_PORT_WRAPPER_ENTITY, NoopRenderer::new);
    }

    private static void setupColorProviders() {
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            int thisColor = FocalPortBlock.getColor(world, pos);
            return thisColor;
        }, (Block[])new Block[]{(Block)DuckyCasting.FOCAL_PORT_BLOCK.get()});
    }

    private static void setupScryingDisplayers() {
        ScryingLensOverlayRegistry.addDisplayer((Block)((Block)DuckyCasting.FOCAL_PORT_BLOCK.get()), (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt2223$temp = world.m_7702_(pos);
            if (patt2223$temp instanceof FocalPortBlockEntity) {
                FocalPortBlockEntity fpbe = (FocalPortBlockEntity)patt2223$temp;
                if (!fpbe.hasFocus()) {
                    lines.add(new Pair((Object)ItemStack.f_41583_, (Object)Component.m_237113_((String)"No Focus")));
                } else {
                    ItemStack focusStack = fpbe.m_8020_(0);
                    CompoundTag tag = HexItems.FOCUS.readIotaTag(focusStack);
                    if (tag != null) {
                        lines.add(new Pair((Object)new ItemStack((ItemLike)Items.f_41852_), (Object)IotaType.getDisplay((CompoundTag)tag)));
                    }
                    lines.add(new Pair((Object)focusStack, (Object)focusStack.m_41786_().m_6881_().m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)fpbe.getColor())))));
                }
            }
        });
    }
}

