/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.forge.hexcasting;

import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.forge.cap.ForgeCapabilityHandler;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import at.petrak.hexcasting.forge.cap.adimpl.CapStaticIotaHolder;
import com.samsthenerd.duckyperiphs.ducks.DuckItem;
import com.samsthenerd.duckyperiphs.forge.hexcasting.EntityWrapperIotaCap;
import com.samsthenerd.duckyperiphs.hexcasting.FocalPortWrapperEntity;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class DuckyCastingCaps {
    public static void attachEntityCaps(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity instanceof FocalPortWrapperEntity) {
            FocalPortWrapperEntity fpEnt = (FocalPortWrapperEntity)entity;
            evt.addCapability(ForgeCapabilityHandler.IOTA_STORAGE_CAP, DuckyCastingCaps.provide(fpEnt, HexCapabilities.IOTA, () -> new EntityWrapperIotaCap<FocalPortWrapperEntity>(fpEnt)));
        }
    }

    public static void attachItemCaps(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack itemStack = (ItemStack)evt.getObject();
        Item item = itemStack.m_41720_();
        if (item instanceof DuckItem) {
            DuckItem duckItem = (DuckItem)item;
            evt.addCapability(ForgeCapabilityHandler.IOTA_STATIC_CAP, DuckyCastingCaps.provide(itemStack, HexCapabilities.IOTA, () -> new CapStaticIotaHolder(s -> new PatternIota(HexPattern.fromAngles((String)"aqadweeeede", (HexDir)HexDir.NORTH_EAST)), itemStack)));
        }
    }

    private static <CAP> SimpleProvider<CAP> provide(Entity entity, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return DuckyCastingCaps.provide(() -> ((Entity)entity).m_213877_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BlockEntity be, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return DuckyCastingCaps.provide(() -> ((BlockEntity)be).m_58901_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(ItemStack stack, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return DuckyCastingCaps.provide(() -> ((ItemStack)stack).m_41619_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BooleanSupplier invalidated, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return new SimpleProvider<CAP>(invalidated, capability, LazyOptional.of(supplier));
    }

    private record SimpleProvider<CAP>(BooleanSupplier invalidated, Capability<CAP> capability, LazyOptional<CAP> instance) implements ICapabilityProvider
    {
        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.invalidated.getAsBoolean()) {
                return LazyOptional.empty();
            }
            return cap == this.capability ? this.instance.cast() : LazyOptional.empty();
        }
    }
}

