/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.ducks;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.ducks.DuckBlockEntity;
import com.samsthenerd.duckyperiphs.ducks.DuckItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DuckBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape head_shape = Block.m_49796_((double)9.0, (double)3.0, (double)6.0, (double)13.0, (double)7.0, (double)10.0);
    protected static final VoxelShape body_shape = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)11.0);
    protected static final VoxelShape rw_shape = Block.m_49796_((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)4.0, (double)5.0);
    protected static final VoxelShape lw_shape = Block.m_49796_((double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)4.0, (double)12.0);
    protected static final VoxelShape nose_shape = Block.m_49796_((double)13.0, (double)4.0, (double)7.0, (double)14.0, (double)5.0, (double)9.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)head_shape, (VoxelShape[])new VoxelShape[]{body_shape, rw_shape, lw_shape, nose_shape});

    public DuckBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DuckBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{POWERED});
    }

    public int getColor(BlockGetter view, BlockPos pos) {
        BlockEntity duck_ent = view.m_7702_(pos);
        if (duck_ent instanceof DuckBlockEntity) {
            return ((DuckBlockEntity)duck_ent).getBlockColor();
        }
        return 1000;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof DuckBlockEntity) {
            ((DuckBlockEntity)blockEntity).setCustomName(itemStack.m_41786_());
        }
        if ((blockEntity = world.m_7702_(pos)) instanceof DuckBlockEntity) {
            ((DuckBlockEntity)blockEntity).setColor(((DuckItem)itemStack.m_41720_()).m_41121_(itemStack));
            if (((DuckItem)itemStack.m_41720_()).hasRepairCost(itemStack).booleanValue()) {
                ((DuckBlockEntity)blockEntity).setRepairCost(((DuckItem)itemStack.m_41720_()).getRepairCost(itemStack));
            } else {
                ((DuckBlockEntity)blockEntity).setRepairCost(1000000);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        if (direction == Direction.DOWN || direction == Direction.UP) {
            direction = Direction.NORTH;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return DuckBlock.rotateShape(Direction.EAST, direction, SHAPE);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public void quack(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            float pitch = (float)(Math.random() * 0.2 + 0.9);
            world.m_142346_(null, (GameEvent)DuckyPeriphs.QUACK_GAME_EVENT.get(), pos);
            world.m_5594_(null, pos, (SoundEvent)DuckyPeriphs.QUACK_SOUND_EVENT.get(), SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        boolean bl = world.m_276867_(pos);
        if (bl != (Boolean)state.m_61143_((Property)POWERED)) {
            if (bl) {
                this.quack(world, pos);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !world.m_276867_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.quack(world, pos);
        return InteractionResult.CONSUME;
    }
}

