/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs;

import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.ducks.DuckBlock;
import com.samsthenerd.duckyperiphs.ducks.DuckItem;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCastingClient;
import com.samsthenerd.duckyperiphs.hexcasting.DummyNoHex;
import com.samsthenerd.duckyperiphs.peripherals.WeatherMachine.WeatherMachineBlock;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardBlock;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreen;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckyPeriphsClientInit {
    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)DuckyPeriphs.WEATHER_MACHINE_BLOCK.get(), (Block)DuckyPeriphs.KEYBOARD_BLOCK.get(), (Block)DuckyPeriphs.DUCK_BLOCK.get()});
        MenuRegistry.registerScreenFactory(DuckyPeriphs.KEYBOARD_SCREEN_HANDLER, KeyboardScreen::new);
        DuckyPeriphsClientInit.registerColorProviders();
        if (Platform.isModLoaded((String)"hexcasting")) {
            DuckyCastingClient.init();
        } else {
            RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)DummyNoHex.FOCAL_PORT_BLOCK.get(), (Block)DummyNoHex.CONJURED_DUCKY_BLOCK.get()});
        }
    }

    private static void registerColorProviders() {
        ColorHandlerRegistry.registerBlockColors((state, view, pos, tintIndex) -> {
            if (view == null || pos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            return BiomeColors.m_108793_((BlockAndTintGetter)view, (BlockPos)pos);
        }, (Block[])new Block[]{(Block)DuckyPeriphs.WEATHER_MACHINE_BLOCK.get()});
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0), (ItemLike[])new ItemLike[]{((WeatherMachineBlock)((Object)DuckyPeriphs.WEATHER_MACHINE_BLOCK.get())).m_5456_()});
        ColorHandlerRegistry.registerBlockColors((state, view, pos, tintIndex) -> {
            if (view == null || pos == null) {
                return DyeColor.BLUE.m_41070_();
            }
            return ((KeyboardBlock)((Object)((Object)DuckyPeriphs.KEYBOARD_BLOCK.get()))).getKeyCaps((BlockGetter)view, pos).getZoneColor(tintIndex);
        }, (Block[])new Block[]{(Block)DuckyPeriphs.KEYBOARD_BLOCK.get()});
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> KeyCaps.fromItemStack(stack).getZoneColor(tintIndex), (ItemLike[])new ItemLike[]{(ItemLike)DuckyPeriphs.KEYBOARD_ITEM.get()});
        ColorHandlerRegistry.registerBlockColors((state, view, pos, tintIndex) -> ((DuckBlock)((Object)((Object)DuckyPeriphs.DUCK_BLOCK.get()))).getColor((BlockGetter)view, pos), (Block[])new Block[]{(Block)DuckyPeriphs.DUCK_BLOCK.get()});
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            return ((DuckItem)((Object)((Object)DuckyPeriphs.DUCK_ITEM.get()))).m_41121_(stack);
        }, (ItemLike[])new ItemLike[]{(ItemLike)DuckyPeriphs.DUCK_ITEM.get()});
    }
}

