/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs;

import com.google.common.base.Suppliers;
import com.samsthenerd.duckyperiphs.DPRecipeSerializer;
import com.samsthenerd.duckyperiphs.ducks.DuckBlock;
import com.samsthenerd.duckyperiphs.ducks.DuckBlockEntity;
import com.samsthenerd.duckyperiphs.ducks.DuckItem;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.DummyNoHex;
import com.samsthenerd.duckyperiphs.misc.DuckyBanners;
import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorBlock;
import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorTile;
import com.samsthenerd.duckyperiphs.peripherals.WeatherMachine.WeatherMachineBlock;
import com.samsthenerd.duckyperiphs.peripherals.WeatherMachine.WeatherMachineTile;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardBlock;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardItem;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreenHandler;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardUtils;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlock;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlockEntity;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckyPeriphs {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ducky-periphs");
    public static final String MOD_ID = "ducky-periphs";
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static DeferredRegister<Item> items = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256913_);
    public static DeferredRegister<Block> blocks = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256747_);
    public static Map<RegistrySupplier<? extends Block>, Item.Properties> blockItems = new HashMap<RegistrySupplier<? extends Block>, Item.Properties>();
    public static DeferredRegister<BlockEntityType<?>> blockEntities = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256922_);
    public static DeferredRegister<EntityType<?>> entities = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256939_);
    public static final DeferredRegister<SoundEvent> sounds = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256840_);
    public static final DeferredRegister<GameEvent> gameEvents = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256827_);
    public static final DeferredRegister<MenuType<?>> screenHandlers = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_256798_);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"ducky-periphs", (ResourceKey)Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> CC_PERIPHS_GROUP = TABS.register("test_tab", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"itemGroup.ducky-periphs.general"), () -> new ItemStack((ItemLike)DUCK_ITEM.get())));
    public static RegistrySupplier<WeatherMachineBlock> WEATHER_MACHINE_BLOCK = DuckyPeriphs.blockItem("weather_machine_block", () -> new WeatherMachineBlock(DuckyPeriphs.peripheralBlockSettings()));
    public static RegistrySupplier<BlockEntityType<WeatherMachineTile>> WEATHER_MACHINE_TILE = blockEntities.register(new ResourceLocation("ducky-periphs", "weather_machine_tile"), () -> BlockEntityType.Builder.m_155273_(WeatherMachineTile::new, (Block[])new Block[]{(Block)WEATHER_MACHINE_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<EntityDetectorBlock> ENTITY_DETECTOR_BLOCK = DuckyPeriphs.blockItem("entity_detector_block", () -> new EntityDetectorBlock(DuckyPeriphs.peripheralBlockSettings()));
    public static RegistrySupplier<BlockEntityType<EntityDetectorTile>> ENTITY_DETECTOR_TILE = blockEntities.register(new ResourceLocation("ducky-periphs", "entity_detector_tile"), () -> BlockEntityType.Builder.m_155273_(EntityDetectorTile::new, (Block[])new Block[]{(Block)ENTITY_DETECTOR_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<KeyboardBlock> KEYBOARD_BLOCK = DuckyPeriphs.blockNoItem("keyboard_block", () -> new KeyboardBlock(DuckyPeriphs.peripheralBlockSettings().m_155954_(0.7f)));
    public static RegistrySupplier<BlockEntityType<KeyboardTile>> KEYBOARD_TILE = blockEntities.register(new ResourceLocation("ducky-periphs", "keyboard_tile"), () -> BlockEntityType.Builder.m_155273_(KeyboardTile::new, (Block[])new Block[]{(Block)KEYBOARD_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<KeyboardItem> KEYBOARD_ITEM = DuckyPeriphs.item("keyboard_block", () -> new KeyboardItem((Block)KEYBOARD_BLOCK.get(), new Item.Properties().arch$tab(CC_PERIPHS_GROUP)));
    public static final MenuType<KeyboardScreenHandler> KEYBOARD_SCREEN_HANDLER = MenuRegistry.ofExtended(KeyboardScreenHandler::new);
    public static final ResourceLocation KEYBOARD_PRESS_PACKET_ID = new ResourceLocation("ducky-periphs", "keyboard_press");
    public static final RegistrySupplier<DuckBlock> DUCK_BLOCK = DuckyPeriphs.blockNoItem("duck_block", () -> new DuckBlock(BlockBehaviour.Properties.m_284310_().m_155954_(0.2f)));
    public static RegistrySupplier<BlockEntityType<DuckBlockEntity>> DUCK_BLOCK_ENTITY = blockEntities.register(new ResourceLocation("ducky-periphs", "duck_block_entity"), () -> BlockEntityType.Builder.m_155273_(DuckBlockEntity::new, (Block[])new Block[]{(Block)DUCK_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<DuckItem> DUCK_ITEM = DuckyPeriphs.item("duck_block", () -> new DuckItem((Block)DUCK_BLOCK.get(), DuckyPeriphs.dpItemSettings()));
    public static RegistrySupplier<SoundEvent> QUACK_SOUND_EVENT = DuckyPeriphs.soundEvent("quack");
    public static RegistrySupplier<GameEvent> QUACK_GAME_EVENT = DuckyPeriphs.gameEvent("quack", 16);
    public static final RegistrySupplier<SculkophoneBlock> SCULKOPHONE_BLOCK = DuckyPeriphs.blockItem("sculkophone_block", () -> new SculkophoneBlock(DuckyPeriphs.peripheralBlockSettings().m_155954_(0.7f)));
    public static RegistrySupplier<BlockEntityType<SculkophoneBlockEntity>> SCULKOPHONE_BLOCK_ENTITY = blockEntities.register("sculkophone_block_entity", () -> BlockEntityType.Builder.m_155273_(SculkophoneBlockEntity::new, (Block[])new Block[]{(Block)SCULKOPHONE_BLOCK.get()}).m_58966_(null));
    public static RegistrySupplier<SoundEvent> SCULKOPHONE_CLICKING_EVENT = DuckyPeriphs.soundEvent("sculkophone_clicking");
    public static RegistrySupplier<SoundEvent> SCULKOPHONE_CLICKING_STOP_EVENT = DuckyPeriphs.soundEvent("sculkophone_clicking_stop");
    public static final RegistrySupplier<BannerPatternItem> DUCKY_PATTERN_ITEM = DuckyPeriphs.item("ducky_banner_pattern", () -> new BannerPatternItem(DuckyBanners.DUCKY_PATTERN_ITEM_KEY, new Item.Properties().m_41487_(1).arch$tab((CreativeModeTab)BuiltInRegistries.f_279662_.m_7745_(new ResourceLocation("ingredients")))));
    public static final ResourceLocation keyboardLootTable = new ResourceLocation("ducky-periphs", "chests/keyboards");

    public static final void logPrint(String message) {
        if (Platform.isDevelopmentEnvironment()) {
            LOGGER.info(message);
        }
    }

    public static void onInitialize() {
        DuckyPeriphs.setupNetworkStuff();
        DuckyPeriphs.setupMisc();
        DPRecipeSerializer.init();
        if (Platform.isModLoaded((String)"hexcasting")) {
            DuckyCasting.init();
        } else {
            DummyNoHex.init();
        }
        blocks.register();
        blockItems.forEach((block, itemprops) -> items.register(block.getId(), () -> new BlockItem((Block)block.get(), itemprops)));
        items.register();
        blockEntities.register();
        entities.register();
        sounds.register();
        gameEvents.register();
        screenHandlers.register();
        TABS.register();
        DuckyBanners.registerBannerPatterns();
    }

    private static void setupNetworkStuff() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "key_press_packet"), (buf, context) -> KeyboardUtils.keyPressHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "key_up_packet"), (buf, context) -> KeyboardUtils.keyUpHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "char_typed_packet"), (buf, context) -> KeyboardUtils.charTypedHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "event_sent_packet"), (buf, context) -> KeyboardUtils.eventShortcutHandler(buf, context));
    }

    private static void setupMisc() {
        screenHandlers.register(new ResourceLocation(MOD_ID, "keyboard_screen_handler"), () -> KEYBOARD_SCREEN_HANDLER);
    }

    private static BlockBehaviour.Properties peripheralBlockSettings() {
        return BlockBehaviour.Properties.m_284310_().m_155954_(1.3f);
    }

    private static Item.Properties dpItemSettings() {
        return new Item.Properties().arch$tab(CC_PERIPHS_GROUP);
    }

    public static <T extends Block> RegistrySupplier<T> blockNoItem(String name, Supplier<T> block) {
        return blocks.register(new ResourceLocation(MOD_ID, name), block);
    }

    public static <T extends Item> RegistrySupplier<T> item(String name, Supplier<T> item) {
        return items.register(new ResourceLocation(MOD_ID, name), item);
    }

    public static <T extends Block> RegistrySupplier<T> blockItem(String name, Supplier<T> block) {
        return DuckyPeriphs.blockItem(name, block, DuckyPeriphs.dpItemSettings());
    }

    public static <T extends Block> RegistrySupplier<T> blockItem(String name, Supplier<T> block, Item.Properties props) {
        RegistrySupplier<T> blockRegistered = DuckyPeriphs.blockNoItem(name, block);
        blockItems.put(blockRegistered, props);
        return blockRegistered;
    }

    public static RegistrySupplier<SoundEvent> soundEvent(String id) {
        return sounds.register(new ResourceLocation(MOD_ID, id), () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MOD_ID, id)));
    }

    public static RegistrySupplier<GameEvent> gameEvent(String id, int range) {
        return gameEvents.register(new ResourceLocation(MOD_ID, id), () -> new GameEvent(new ResourceLocation(MOD_ID, id).toString(), range));
    }

    public static boolean shouldAddKeyboards(ResourceLocation id, boolean builtin) {
        return builtin && (BuiltInLootTables.f_78742_.equals((Object)id) || BuiltInLootTables.f_78759_.equals((Object)id) || BuiltInLootTables.f_78764_.equals((Object)id) || BuiltInLootTables.f_78689_.equals((Object)id) || BuiltInLootTables.f_78686_.equals((Object)id));
    }
}

