/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.net;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.liko.dronedetector.common.ServerValues;

public record S2CServerSettings(double range, boolean requireLineOfSight, List<String> transparentBlocks) {
    public static void encode(S2CServerSettings msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.range);
        buf.writeBoolean(msg.requireLineOfSight);
        buf.writeInt(msg.transparentBlocks.size());
        for (String block : msg.transparentBlocks) {
            buf.m_130070_(block);
        }
    }

    public static S2CServerSettings decode(FriendlyByteBuf buf) {
        double range = buf.readDouble();
        boolean loS = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<String> blocks = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            blocks.add(buf.m_130277_());
        }
        return new S2CServerSettings(range, loS, blocks);
    }

    public static void handle(S2CServerSettings msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> ServerValues.setValues(msg.range(), msg.requireLineOfSight(), msg.transparentBlocks()));
        c.setPacketHandled(true);
    }
}

