/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.liko.dronedetector.common.ServerConfig;

public final class ServerValues {
    private static volatile double range = -1.0;
    private static volatile boolean requireLineOfSight = false;
    private static volatile List<String> transparentBlocks = new ArrayList<String>();
    private static volatile boolean synced = false;

    public static void setRange(double r) {
        range = r;
        synced = true;
    }

    public static void setRequireLineOfSight(boolean value) {
        requireLineOfSight = value;
        synced = true;
    }

    public static void setTransparentBlocks(List<String> blocks) {
        transparentBlocks = new ArrayList<String>(blocks);
        synced = true;
    }

    public static void setValues(double r, boolean loS, List<String> blocks) {
        range = r;
        requireLineOfSight = loS;
        transparentBlocks = new ArrayList<String>(blocks);
        synced = true;
    }

    public static void reset() {
        range = -1.0;
        requireLineOfSight = false;
        transparentBlocks.clear();
        synced = false;
    }

    public static double getRange() {
        return synced && range > 0.0 ? range : (Double)ServerConfig.RANGE.get();
    }

    public static boolean getRequireLineOfSight() {
        return synced ? requireLineOfSight : (Boolean)ServerConfig.REQUIRE_LINE_OF_SIGHT.get();
    }

    public static List<String> getTransparentBlocks() {
        return synced ? new ArrayList<String>(transparentBlocks) : new ArrayList((Collection)ServerConfig.TRANSPARENT_BLOCKS.get());
    }

    private ServerValues() {
    }
}

