/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.common;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.liko.dronedetector.common.ServerConfig;
import ru.liko.dronedetector.net.DDNetwork;
import ru.liko.dronedetector.net.S2CServerSettings;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ServerEvents {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            DDNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CServerSettings((Double)ServerConfig.RANGE.get(), (Boolean)ServerConfig.REQUIRE_LINE_OF_SIGHT.get(), new ArrayList<String>((Collection)ServerConfig.TRANSPARENT_BLOCKS.get())));
        }
    }

    @SubscribeEvent
    public static void onServerConfigReload(ModConfigEvent.Reloading e) {
        if (e.getConfig().getType() != ModConfig.Type.SERVER) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        S2CServerSettings pkt = new S2CServerSettings((Double)ServerConfig.RANGE.get(), (Boolean)ServerConfig.REQUIRE_LINE_OF_SIGHT.get(), new ArrayList<String>((Collection)ServerConfig.TRANSPARENT_BLOCKS.get()));
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            DDNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)pkt);
        }
    }

    private ServerEvents() {
    }
}

