/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.common;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class ServerConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    private static final ForgeConfigSpec.Builder b;
    public static final ForgeConfigSpec.DoubleValue RANGE;
    public static final ForgeConfigSpec.BooleanValue REQUIRE_LINE_OF_SIGHT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TRANSPARENT_BLOCKS;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
    }

    private ServerConfig() {
    }

    static {
        b = new ForgeConfigSpec.Builder();
        b.push("detector");
        RANGE = b.comment("Drone detection radius in meters (server-controlled)").defineInRange("range", 64.0, 8.0, 1024.0);
        REQUIRE_LINE_OF_SIGHT = b.comment("Require line-of-sight for detection (walls/blocks block the signal)").define("requireLineOfSight", false);
        TRANSPARENT_BLOCKS = b.comment(new String[]{"Blocks that are transparent to detector signal (only used if requireLineOfSight=true)", "Format: namespace:block_id, e.g. minecraft:oak_leaves"}).defineListAllowEmpty(Arrays.asList("signalTransparentBlocks"), () -> Arrays.asList("minecraft:oak_leaves", "minecraft:spruce_leaves", "minecraft:birch_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "minecraft:mangrove_leaves", "minecraft:cherry_leaves", "minecraft:azalea_leaves", "minecraft:flowering_azalea_leaves", "minecraft:glass", "minecraft:glass_pane", "minecraft:white_stained_glass", "minecraft:orange_stained_glass", "minecraft:magenta_stained_glass", "minecraft:light_blue_stained_glass", "minecraft:yellow_stained_glass", "minecraft:lime_stained_glass", "minecraft:pink_stained_glass", "minecraft:gray_stained_glass", "minecraft:light_gray_stained_glass", "minecraft:cyan_stained_glass", "minecraft:purple_stained_glass", "minecraft:blue_stained_glass", "minecraft:brown_stained_glass", "minecraft:green_stained_glass", "minecraft:red_stained_glass", "minecraft:black_stained_glass"), obj -> obj instanceof String);
        b.pop();
        SERVER_SPEC = b.build();
    }
}

