/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import ru.liko.dronedetector.client.ClientConfig;
import ru.liko.dronedetector.common.DroneTags;
import ru.liko.dronedetector.common.ServerValues;
import ru.liko.dronedetector.item.DroneDetectorItem;
import ru.liko.dronedetector.registry.ModSounds;

public final class DroneTracker {
    public static final DroneTracker INSTANCE = new DroneTracker();
    private final List<Target> snapshot = new ArrayList<Target>();
    private final Map<UUID, Target> targetPool = new HashMap<UUID, Target>();
    private UUID nearestId = null;
    private int beepCooldownTicks = 0;
    private int ticksSinceLastScan = 0;
    private AABB cachedSearchBox = null;
    private double cachedRange = -1.0;
    private Boolean cachedDetectorState = null;
    private int detectorStateCacheTicks = 0;
    private static final int DETECTOR_CACHE_DURATION = 10;
    private static final int DEFAULT_SCAN_INTERVAL = 5;

    private DroneTracker() {
    }

    public List<Target> getSnapshotLimited(int limit) {
        if (this.snapshot.size() <= limit) {
            return Collections.unmodifiableList(this.snapshot);
        }
        return Collections.unmodifiableList(this.snapshot.subList(0, Math.max(0, limit)));
    }

    public Optional<Target> getNearest() {
        return this.snapshot.isEmpty() ? Optional.empty() : Optional.of(this.snapshot.get(0));
    }

    private boolean hasActiveDetectorCached(Player p) {
        if (p == null) {
            return false;
        }
        if (this.detectorStateCacheTicks > 0) {
            --this.detectorStateCacheTicks;
            return this.cachedDetectorState != null && this.cachedDetectorState != false;
        }
        boolean result = DroneTracker.checkActiveDetector(p);
        this.cachedDetectorState = result;
        this.detectorStateCacheTicks = 10;
        return result;
    }

    private static boolean checkActiveDetector(Player p) {
        ItemStack main = p.m_21205_();
        if (main.m_41720_() instanceof DroneDetectorItem && DroneDetectorItem.isActive(main)) {
            return true;
        }
        ItemStack off = p.m_21206_();
        if (off.m_41720_() instanceof DroneDetectorItem && DroneDetectorItem.isActive(off)) {
            return true;
        }
        Inventory inv = p.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack st = inv.m_8020_(i);
            if (!(st.m_41720_() instanceof DroneDetectorItem) || !DroneDetectorItem.isActive(st)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasActiveDetector(Player p) {
        return INSTANCE.hasActiveDetectorCached(p);
    }

    public static void invalidateDetectorCache() {
        DroneTracker.INSTANCE.cachedDetectorState = null;
        DroneTracker.INSTANCE.detectorStateCacheTicks = 0;
    }

    public void tick(Minecraft mc) {
        boolean onlyNearestBeep;
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        boolean hasDetector = this.hasActiveDetectorCached((Player)player);
        if (!hasDetector) {
            this.snapshot.clear();
            this.targetPool.clear();
            this.nearestId = null;
            this.beepCooldownTicks = 0;
            this.cachedSearchBox = null;
            return;
        }
        int scanInterval = 5;
        try {
            scanInterval = (Integer)ClientConfig.SCAN_INTERVAL.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.ticksSinceLastScan;
        if (this.ticksSinceLastScan >= scanInterval) {
            this.ticksSinceLastScan = 0;
            this.performScan((Player)player, (Level)level);
        }
        if ((onlyNearestBeep = ((Boolean)ClientConfig.ONLY_NEAREST_BEEP.get()).booleanValue()) && !this.snapshot.isEmpty()) {
            Target nearest = this.snapshot.get(0);
            if (!nearest.id.equals(this.nearestId)) {
                this.nearestId = nearest.id;
                this.beepCooldownTicks = 0;
            }
            this.handleBeep((Level)level, (Player)player, nearest, this.getEffectiveRange((Level)level, (Player)player));
        } else {
            this.nearestId = null;
        }
        if (this.beepCooldownTicks > 0) {
            --this.beepCooldownTicks;
        }
    }

    private void performScan(Player player, Level level) {
        double baseRange = ServerValues.getRange();
        double effectiveRange = this.getEffectiveRange(level, player);
        if (this.cachedSearchBox == null || Math.abs(this.cachedRange - effectiveRange) > 0.1) {
            this.cachedSearchBox = player.m_20191_().m_82400_(effectiveRange);
            this.cachedRange = effectiveRange;
        }
        double rangeSq = effectiveRange * effectiveRange;
        List found = level.m_6443_(Entity.class, this.cachedSearchBox, e -> e != player && e.m_20280_((Entity)player) <= rangeSq && this.isDroneCandidate((Entity)e, level, player));
        HashSet<UUID> foundIds = new HashSet<UUID>();
        for (Entity e2 : found) {
            UUID id = e2.m_20148_();
            foundIds.add(id);
            Target target = this.targetPool.computeIfAbsent(id, Target::new);
            target.update(e2, player);
        }
        this.targetPool.entrySet().removeIf(entry -> !foundIds.contains(entry.getKey()));
        this.snapshot.clear();
        for (UUID id : foundIds) {
            Target t2 = this.targetPool.get(id);
            if (t2 == null) continue;
            this.snapshot.add(t2);
        }
        this.snapshot.sort(Comparator.comparingDouble(t -> t.distance));
    }

    private double getEffectiveRange(Level level, Player player) {
        double baseRange = ServerValues.getRange();
        boolean weatherAffects = true;
        try {
            weatherAffects = (Boolean)ClientConfig.WEATHER_AFFECTS_RANGE.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (weatherAffects) {
            if (level.m_46470_()) {
                baseRange *= 0.6;
            } else if (level.m_46471_()) {
                baseRange *= 0.8;
            }
        }
        if (player.m_5842_()) {
            return 0.0;
        }
        if (player.m_20186_() < 0.0 && level.m_46472_() == Level.f_46428_) {
            baseRange *= 0.5;
        }
        return baseRange;
    }

    private void handleBeep(Level level, Player player, Target nearest, double range) {
        if (this.beepCooldownTicks > 0) {
            return;
        }
        double d = nearest.distance;
        double minD = 5.0;
        double maxD = Math.max(range, 16.0);
        double t = Mth.m_14008_((double)((d - minD) / (maxD - minD)), (double)0.0, (double)1.0);
        int minPeriod = (Integer)ClientConfig.BEEP_MIN_PERIOD.get();
        int maxPeriod = (Integer)ClientConfig.BEEP_MAX_PERIOD.get();
        int period = (int)Mth.m_14139_((double)t, (double)minPeriod, (double)maxPeriod);
        float minPitch = ((Double)ClientConfig.BEEP_PITCH_MAX.get()).floatValue();
        float maxPitch = ((Double)ClientConfig.BEEP_PITCH_MIN.get()).floatValue();
        float pitch = (float)Mth.m_14139_((double)t, (double)minPitch, (double)maxPitch);
        float volume = ((Double)ClientConfig.BEEP_VOLUME.get()).floatValue();
        SoundEvent sound = ModSounds.DETECTOR_BEEP.isPresent() ? (SoundEvent)ModSounds.DETECTOR_BEEP.get() : (SoundEvent)SoundEvents.f_12215_.m_203334_();
        level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, volume, pitch, false);
        this.beepCooldownTicks = Math.max(1, period);
    }

    private boolean isDroneCandidate(Entity e, Level level, Player player) {
        if (!e.m_6084_()) {
            return false;
        }
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)e.m_6095_());
        if (key == null) {
            return false;
        }
        boolean isCorrectType = false;
        if (e.m_6095_().m_204039_(DroneTags.DRONE_TARGETS)) {
            isCorrectType = true;
        } else {
            String ns = key.m_135827_();
            String path = key.m_135815_();
            if ((ns.equals("sbw") || ns.equals("superbwarfare")) && path.contains("drone")) {
                isCorrectType = true;
            }
        }
        if (!isCorrectType) {
            return false;
        }
        boolean requireLoS = ServerValues.getRequireLineOfSight();
        return !requireLoS || this.hasLineOfSight(player, e, level);
    }

    private boolean hasLineOfSight(Player player, Entity target, Level level) {
        BlockHitResult blockHit;
        BlockState blockState;
        String blockId;
        Vec3 playerEyes = player.m_146892_();
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        List<String> transparentBlocks = ServerValues.getTransparentBlocks();
        HashSet<String> transparentSet = new HashSet<String>(transparentBlocks);
        BlockHitResult result = level.m_45547_(new ClipContext(playerEyes, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        return result.m_6662_() == HitResult.Type.BLOCK && transparentSet.contains(blockId = BuiltInRegistries.f_256975_.m_7981_((Object)(blockState = level.m_8055_((blockHit = result).m_82425_())).m_60734_()).toString());
    }

    private static String extractDroneOwnerName(Entity e) {
        try {
            EntityDataAccessor accessor;
            String controllerUUID;
            SynchedEntityData entityData = e.m_20088_();
            Class<?> clazz = e.getClass();
            Field controllerField = clazz.getField("CONTROLLER");
            if (controllerField != null && (controllerUUID = (String)entityData.m_135370_(accessor = (EntityDataAccessor)controllerField.get(null))) != null && !controllerUUID.equals("undefined") && !controllerUUID.equals("none")) {
                try {
                    UUID uuid = UUID.fromString(controllerUUID);
                    Player owner = e.m_9236_().m_46003_(uuid);
                    if (owner != null) {
                        Team team = owner.m_5647_();
                        if (team != null) {
                            return team.m_5758_() + " Drone";
                        }
                        return owner.m_7755_().getString() + "'s Drone";
                    }
                    return "Drone (offline)";
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.m_5446_().getString();
    }

    @Deprecated
    private boolean isDroneCandidate(Entity e) {
        if (!e.m_6084_()) {
            return false;
        }
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)e.m_6095_());
        if (key == null) {
            return false;
        }
        if (e.m_6095_().m_204039_(DroneTags.DRONE_TARGETS)) {
            return true;
        }
        String ns = key.m_135827_();
        String path = key.m_135815_();
        return (ns.equals("sbw") || ns.equals("superbwarfare")) && path.contains("drone");
    }

    public static final class Target {
        public final UUID id;
        public Entity entity;
        public String name;
        public double distance;
        public float bearingDeg;

        Target(UUID id) {
            this.id = id;
        }

        void update(Entity e, Player player) {
            this.entity = e;
            this.name = DroneTracker.extractDroneOwnerName(e);
            this.distance = e.m_20270_((Entity)player);
            Vec3 vec = e.m_20182_().m_82546_(player.m_20182_());
            float yawTo = (float)(Mth.m_14136_((double)vec.f_82481_, (double)vec.f_82479_) * 57.29577951308232) - 90.0f;
            this.bearingDeg = Mth.m_14177_((float)(yawTo - player.m_146908_()));
        }
    }
}

