/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.client;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import ru.liko.dronedetector.client.DroneTracker;
import ru.liko.dronedetector.common.ServerValues;

public final class DetectorCenterHud {
    public static final IGuiOverlay OVERLAY = (gui, gfx, pt, sw, sh) -> {
        Object title;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        if (!DroneTracker.hasActiveDetector((Player)mc.f_91074_)) {
            return;
        }
        List<DroneTracker.Target> targets = DroneTracker.INSTANCE.getSnapshotLimited(5);
        double range = Math.max(8.0, ServerValues.getRange());
        Font font = mc.f_91062_;
        int margin = 8;
        int lineH = 10;
        int pad = 5;
        int barW = 120;
        int barH = 6;
        int listN = Math.min(5, targets.size());
        int panelW = Math.max(160, barW + pad * 2);
        int panelH = 18 + pad * 2 + (listN > 0 ? listN * lineH + 4 : 0) + barH + 6;
        int x = sw - panelW - margin;
        int y = sh - panelH - margin;
        int bg = 0x66000000;
        int br = 0x55FFFFFF;
        gfx.m_280509_(x, y, x + panelW, y + panelH, bg);
        gfx.m_280509_(x, y, x + panelW, y + 1, br);
        gfx.m_280509_(x, y + panelH - 1, x + panelW, y + panelH, br);
        gfx.m_280509_(x, y, x + 1, y + panelH, br);
        gfx.m_280509_(x + panelW - 1, y, x + panelW, y + panelH, br);
        int cy = y + pad;
        double fillFrac = 0.0;
        int barColor = -11141291;
        Optional<DroneTracker.Target> nearestOpt = DroneTracker.INSTANCE.getNearest();
        if (nearestOpt.isPresent()) {
            DroneTracker.Target t = nearestOpt.get();
            int approx = DetectorCenterHud.approxMeters(t.distance);
            title = "Nearest UAV: \u2248" + approx + "m";
            fillFrac = 1.0 - Math.min(1.0, t.distance / range);
            barColor = DetectorCenterHud.colorByDistance(t.distance, range);
        } else {
            title = "No UAVs Detected";
        }
        int titleW = font.m_92895_((String)title);
        gfx.m_280056_(font, (String)title, x + (panelW - titleW) / 2, cy, 0xFFFFFF, false);
        int barX = x + pad;
        int barY = cy += 14;
        cy += barH + 6;
        int barBg = -14671840;
        gfx.m_280509_(barX, barY, barX + barW, barY + barH, barBg);
        int fillW = (int)Math.round((double)barW * fillFrac);
        if (fillW > 0) {
            gfx.m_280509_(barX, barY, barX + fillW, barY + barH, barColor);
        }
        if (!targets.isEmpty()) {
            List<DroneTracker.Target> show = targets.subList(0, listN);
            for (DroneTracker.Target t : show) {
                String line = DetectorCenterHud.clipName(t.name, 18) + "  \u00b7  \u2248" + DetectorCenterHud.approxMeters(t.distance) + "m";
                int color = DetectorCenterHud.listColorByDistance(t.distance, range);
                gfx.m_280056_(font, line, x + pad, cy, color, false);
                cy += lineH;
            }
        }
    };

    private static int approxMeters(double d) {
        return (int)Math.round(d / 5.0) * 5;
    }

    private static String clipName(String s, int max) {
        if (s == null) {
            return "";
        }
        return s.length() <= max ? s : s.substring(0, Math.max(0, max - 1)) + "\u2026";
    }

    private static int colorByDistance(double d, double range) {
        double p = d / Math.max(1.0, range);
        if (p <= 0.25) {
            return -43691;
        }
        if (p <= 0.6) {
            return -171;
        }
        return -11141291;
    }

    private static int listColorByDistance(double d, double range) {
        double p = d / Math.max(1.0, range);
        if (p <= 0.25) {
            return -2263177;
        }
        if (p <= 0.6) {
            return -2237065;
        }
        return -7807608;
    }

    private DetectorCenterHud() {
    }
}

