/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.client;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class ClientConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final ForgeConfigSpec.Builder b;
    public static final ForgeConfigSpec.BooleanValue ONLY_NEAREST_BEEP;
    public static final ForgeConfigSpec.IntValue BEEP_MIN_PERIOD;
    public static final ForgeConfigSpec.IntValue BEEP_MAX_PERIOD;
    public static final ForgeConfigSpec.DoubleValue BEEP_VOLUME;
    public static final ForgeConfigSpec.DoubleValue BEEP_PITCH_MIN;
    public static final ForgeConfigSpec.DoubleValue BEEP_PITCH_MAX;
    public static final ForgeConfigSpec.BooleanValue HUD_ENABLED;
    public static final ForgeConfigSpec.IntValue HUD_LIST_COUNT;
    public static final ForgeConfigSpec.BooleanValue HUD_ANCHOR_RIGHT;
    public static final ForgeConfigSpec.IntValue HUD_X;
    public static final ForgeConfigSpec.IntValue HUD_Y;
    public static final ForgeConfigSpec.IntValue SCAN_INTERVAL;
    public static final ForgeConfigSpec.IntValue LOCK_ON_TIME;
    public static final ForgeConfigSpec.BooleanValue ONLY_DETECT_ACTIVE;
    public static final ForgeConfigSpec.BooleanValue WEATHER_AFFECTS_RANGE;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    private ClientConfig() {
    }

    static {
        b = new ForgeConfigSpec.Builder();
        b.push("audio");
        ONLY_NEAREST_BEEP = b.define("onlyNearestBeep", true);
        BEEP_MIN_PERIOD = b.defineInRange("beepMinPeriod", 6, 1, 200);
        BEEP_MAX_PERIOD = b.defineInRange("beepMaxPeriod", 40, 2, 400);
        BEEP_VOLUME = b.defineInRange("beepVolume", 0.8, 0.0, 2.0);
        BEEP_PITCH_MIN = b.defineInRange("beepPitchMinFar", 0.7, 0.5, 2.0);
        BEEP_PITCH_MAX = b.defineInRange("beepPitchMaxNear", 1.8, 0.5, 3.0);
        b.pop();
        b.push("hud");
        HUD_ENABLED = b.define("enabled", true);
        HUD_LIST_COUNT = b.defineInRange("listCount", 5, 1, 12);
        HUD_ANCHOR_RIGHT = b.define("anchorRight", true);
        HUD_X = b.defineInRange("x", 8, 0, 10000);
        HUD_Y = b.defineInRange("y", 8, 0, 10000);
        b.pop();
        b.push("performance");
        b.comment("Scanning interval in ticks (20 ticks = 1 second). Lower = more responsive but worse performance.");
        SCAN_INTERVAL = b.defineInRange("scanInterval", 5, 1, 20);
        b.pop();
        b.push("realism");
        b.comment("Lock-on time in ticks before target appears on detector. Simulates signal acquisition delay.");
        LOCK_ON_TIME = b.defineInRange("lockOnTime", 10, 5, 100);
        b.comment("Only detect drones that are moving/active (not landed or idle)");
        ONLY_DETECT_ACTIVE = b.define("onlyDetectActive", false);
        b.comment("Weather (rain/thunderstorm) reduces detection range");
        WEATHER_AFFECTS_RANGE = b.define("weatherAffectsRange", true);
        b.pop();
        CLIENT_SPEC = b.build();
    }
}

