/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.entity;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.modernwarfare.dragonrise.Mod;
import com.modernwarfare.dragonrise.config.server.DragonRiseServerConfig;
import com.modernwarfare.dragonrise.init.DRModSounds;
import com.modernwarfare.dragonrise.init.ModEntities;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ZBD04AEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity,
ArmedVehicleEntity {
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_HE = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AMMO_TYPE = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RELOAD_COOLDOWN = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.625f, 0.8f, 3.375f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.625f, 0.46f, 1.0f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.28f, 0.7f, 4.03f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.28f, 0.7f, 4.03f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.71f, 0.53f, 0.9f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.35f, 0.31f, 1.43f), new Quaternionf(), OBB.Part.TURRET);
    private Object living;
    private int reloadCompleteDisplayTime = 0;
    private long reloadCompleteTime = 0L;
    public static final EntityDataAccessor<Integer> LOADED_AMMO = SynchedEntityData.m_135353_(ZBD04AEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ZBD04AEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ZBD04AEntity>)((EntityType)ModEntities.ZBD04A.get()), world);
    }

    public ZBD04AEntity(EntityType<ZBD04AEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new WgMissileWeapon().damage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)DRModSounds.ZTZ99A_FIRE_1P.get()).sound3p((SoundEvent)DRModSounds.ZTZ99A_FIRE_3P.get()).icon(Mod.loc("textures/hud/hud_dty02.png")).ammo((Item)ModItems.WIRE_GUIDE_MISSILE.get()), new CannonShellWeapon().hitDamage((float)((Integer)DragonRiseServerConfig.ZBD04A_HE_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)DragonRiseServerConfig.ZBD04A_HE_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage((float)((Integer)DragonRiseServerConfig.ZBD04A_HE_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.18f).fireTime(2).durability(1).velocity(10.0f).gravity(0.1f).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.HE_5_INCHES.get()).icon(com.atsuishio.superbwarfare.Mod.loc((String)"textures/screens/vehicle_weapon/he_shell.png")).sound1p((SoundEvent)DRModSounds.ZTZ99A_FIRE_1P.get()).sound3p((SoundEvent)DRModSounds.ZTZ99A_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()), new ProjectileWeapon().damage(8.0f).headShot(2.0f).zoom(false).bypassArmorRate(0.45f).ammo((Item)ModItems.HEAVY_AMMO.get()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/hud/hud_5_8mm.png")).sound1p(SoundEvent.m_262824_((ResourceLocation)Mod.loc("textures/sounds/ztz99a/qjy88_shoot.ogg"))).sound3p(SoundEvent.m_262824_((ResourceLocation)Mod.loc("textures/sounds/ztz99a/qjy88_shoot_3p.ogg"))).sound3pFar((SoundEvent)ModSounds.QBZ_191_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.QBZ_191_VERYFAR.get()), new SmallCannonShellWeapon().damage((float)((Integer)VehicleConfig.BMP_2_CANNON_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)VehicleConfig.BMP_2_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.BMP_2_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).icon(com.atsuishio.superbwarfare.Mod.loc((String)"textures/screens/vehicle_weapon/cannon_30mm.png")).sound1p((SoundEvent)ModSounds.BMP_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.LAV_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.LAV_CANNON_VERYFAR.get()).ammo((Item)ModItems.SMALL_SHELL.get())}};
    }

    public float getMaxHealth() {
        return 300.0f;
    }

    public float passengerWeaponYSpeed() {
        return 15.0f;
    }

    public float passengerWeaponXSpeed() {
        return 15.0f;
    }

    public float passengerWeaponMinPitch() {
        return -15.0f;
    }

    public float passengerWeaponMaxPitch() {
        return 60.0f;
    }

    public float turretYSpeed() {
        return 10.0f;
    }

    public float turretXSpeed() {
        return 12.5f;
    }

    public float turretMinPitch() {
        return -7.5f;
    }

    public float turretMaxPitch() {
        return 60.0f;
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return switch (index) {
            case 0 -> new ThirdPersonCameraPosition(4.0 + ClientMouseHandler.custom3pDistanceLerp, 1.5, -0.8669625);
            case 1 -> new ThirdPersonCameraPosition(4.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 1.5, 0.0);
            case 2 -> new ThirdPersonCameraPosition(5.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 1.5, 0.0);
            default -> null;
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(LOADED_HE, (Object)0);
        this.f_19804_.m_135372_(LOADED_AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(GUN_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(RELOAD_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
        compound.m_128405_("LoadedHE", ((Integer)this.f_19804_.m_135370_(LOADED_HE)).intValue());
        compound.m_128405_("LoadedAmmoType", ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE)).intValue());
        compound.m_128405_("WeaponType", this.getWeaponIndex(0));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
        this.f_19804_.m_135381_(LOADED_HE, (Object)compound.m_128451_("LoadedHE"));
        this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)compound.m_128451_("LoadedAmmoType"));
        this.setWeaponIndex(0, compound.m_128451_("WeaponType"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.3f) * damage.floatValue()));
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        Entity entity;
        super.m_6075_();
        this.updateOBB();
        if ((Integer)this.f_19804_.m_135370_(RELOAD_COOLDOWN) == 0 && this.reloadCompleteDisplayTime == 0) {
            this.reloadCompleteDisplayTime = 20;
        } else if (this.reloadCompleteDisplayTime > 0) {
            --this.reloadCompleteDisplayTime;
        }
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) - 1));
        }
        if (this.reloadCoolDown == 80 && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            boolean hasCurrentAmmo = false;
            if ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0) {
                hasCurrentAmmo = this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get()) > 0;
            } else if ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1) {
                boolean bl = hasCurrentAmmo = this.m_18947_((Item)ModItems.HE_5_INCHES.get()) > 0;
            }
            if (hasCurrentAmmo || InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                SoundTool.playLocalSound((Player)player, (SoundEvent)((SoundEvent)DRModSounds.ZBD04A_RELOAD.get()));
            }
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                Player pPlayer;
                Entity entity2 = this.getNthEntity(i);
                if (!(entity2 instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity2))) continue;
                hasCreativeAmmo = true;
            }
            if (this.reloadCoolDown > 0 && ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && (hasCreativeAmmo || this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get()) > 0) || (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1 && (hasCreativeAmmo || this.m_18947_((Item)ModItems.HE_5_INCHES.get()) > 0))) {
                --this.reloadCoolDown;
            }
            if ((Integer)this.f_19804_.m_135370_(RELOAD_COOLDOWN) > 0) {
                this.f_19804_.m_135381_(RELOAD_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(RELOAD_COOLDOWN) - 1));
            }
            this.handleAmmo();
        }
        if (this.m_20096_()) {
            float f0 = 0.6f + 0.25f * Mth.m_14154_((float)(90.0f - (float)ZBD04AEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * org.joml.Math.min((double)ZBD04AEntity.getSubmergedHeight((Entity)this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)ZBD04AEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if ((entity = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + ZBD04AEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + ZBD04AEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.lowHealthWarning();
        this.terrainCompact(4.0f, 5.0f);
        this.inertiaRotate(1.2f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.m_6210_();
    }

    private void handleAmmo() {
        if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)this.getWeaponIndex(0));
        }
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        if (hasCreativeAmmo) {
            this.f_19804_.m_135381_(AMMO, (Object)9999);
            this.f_19804_.m_135381_(MG_AMMO, (Object)9999);
        } else {
            if (this.getWeaponIndex(0) == 3) {
                this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
            } else if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
                this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_(this.getWeapon((int)0).ammo));
            } else {
                this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_(this.getWeapon((int)0).ammo));
            }
            int mgAmmoCount = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get(stack) > 0;
                }
                return false;
            }).mapToInt(arg_0 -> ((Ammo)Ammo.HEAVY).get(arg_0)).sum() + this.m_18947_((Item)ModItems.HEAVY_AMMO.get());
            this.f_19804_.m_135381_(MG_AMMO, (Object)mgAmmoCount);
        }
        if (this.reloadCoolDown <= 0) {
            int loadedAmmoType = (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE);
            if (loadedAmmoType == 0) {
                if ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE) == 0 && (hasCreativeAmmo || this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()))) {
                    this.f_19804_.m_135381_(LOADED_MISSILE, (Object)1);
                    if (!hasCreativeAmmo) {
                        this.consumeItem((Item)ModItems.WIRE_GUIDE_MISSILE.get(), 1);
                    }
                }
            } else if (loadedAmmoType == 1 && (Integer)this.f_19804_.m_135370_(LOADED_HE) == 0 && (hasCreativeAmmo || this.hasItem((Item)ModItems.HE_5_INCHES.get()))) {
                this.f_19804_.m_135381_(LOADED_HE, (Object)1);
                if (!hasCreativeAmmo) {
                    this.consumeItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
            }
        }
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.05 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.1;
    }

    public Vec3 getTurretShootPos(Entity entity, float ticks) {
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.getWeaponIndex(0) == 0 ? this.transformPosition(transform, 0.29f, 0.0f, 2.87f) : (this.getWeaponIndex(0) == 1 ? this.transformPosition(transform, 0.29f, 0.0f, 2.87f) : (this.getWeaponIndex(0) == 2 ? this.transformPosition(transform, 0.54f, 0.12f, 0.34f) : this.transformPosition(transform, 0.0f, 0.0f, 2.81f)));
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public float projectileVelocity(Entity entity) {
        if (this.getWeaponIndex(0) == 0) {
            return 5.0f;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 5.0f;
        }
        if (this.getWeaponIndex(0) == 2) {
            return 36.0f;
        }
        return 20.0f;
    }

    public float projectileGravity(Entity entity) {
        if (this.getWeaponIndex(0) == 0) {
            return 0.15f;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 0.05f;
        }
        if (this.getWeaponIndex(0) == 2) {
            return 0.25f;
        }
        return 0.25f;
    }

    public boolean canCollideBlockBeastly() {
        return this.m_20184_().m_165924_() > 0.3;
    }

    public void vehicleShoot(LivingEntity living, int type) {
        this.living = living;
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            if (!InventoryTool.hasCreativeAmmoBox((Entity)this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        if (type == 0) {
            if (this.reloadCoolDown == 0 && (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1)) {
                if (this.getWeaponIndex(0) == 0 && (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0) {
                    Matrix4f transform = this.getBarrelTransform(1.0f);
                    Vector4f worldPosition = this.transformPosition(transform, 0.33585626f, 0.0f, 3.65f);
                    WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create(living);
                    wgMissileEntity.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                    wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, this.projectileVelocity((Entity)living), 0.0f);
                    wgMissileEntity.m_20202_();
                    this.m_9236_().m_7967_((Entity)wgMissileEntity);
                    this.playShootSound3p(living, 0, 6, 0, 0, new Vec3(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_));
                    this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
                    this.f_19804_.m_135381_(LOADED_MISSILE, (Object)0);
                    this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                    this.reloadCoolDown = 80;
                    this.m_20088_().m_135381_(RELOAD_COOLDOWN, (Object)this.reloadCoolDown);
                    this.f_19804_.m_135381_(FIRE_ANIM, (Object)1);
                } else if (this.getWeaponIndex(0) == 1 && (Integer)this.f_19804_.m_135370_(LOADED_HE) > 0) {
                    Matrix4f transform = this.getBarrelTransform(1.0f);
                    Vector4f worldPosition = this.transformPosition(transform, 0.33585626f, 0.0f, 3.65f);
                    CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
                    CannonShellEntity entityToSpawn = cannonShell.create(living);
                    entityToSpawn.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                    entityToSpawn.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, cannonShell.velocity, 0.02f);
                    this.m_9236_().m_7967_((Entity)entityToSpawn);
                    this.playShootSound3p(living, 0, 8, 16, 32, new Vec3(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_));
                    this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
                    this.f_19804_.m_135381_(LOADED_HE, (Object)0);
                    this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                    this.reloadCoolDown = 80;
                    this.m_20088_().m_135381_(RELOAD_COOLDOWN, (Object)this.reloadCoolDown);
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + 5.0 * this.getBarrelVector((float)1.0f).f_82479_, this.m_20186_() + 0.1, this.m_20189_() + 5.0 * this.getBarrelVector((float)1.0f).f_82481_, 300, 6.0, 0.02, 6.0, 0.005);
                        double x = (double)worldPosition.x + 9.0 * this.getBarrelVector((float)1.0f).f_82479_;
                        double y = (double)worldPosition.y + 9.0 * this.getBarrelVector((float)1.0f).f_82480_;
                        double z = (double)worldPosition.z + 9.0 * this.getBarrelVector((float)1.0f).f_82481_;
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                        int count = 6;
                        for (float i = 9.5f; i < 23.0f; i += 0.5f) {
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)worldPosition.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPosition.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPosition.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, Mth.m_14045_((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
                        }
                        Vector4f worldPositionL = this.transformPosition(transform, -0.35f, 0.0f, 0.0f);
                        Vector4f worldPositionR = this.transformPosition(transform, 0.35f, 0.0f, 0.0f);
                        for (float i = 3.0f; i < 6.0f; i += 0.5f) {
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionL.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionL.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionL.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionR.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionR.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionR.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                        }
                    }
                }
            } else if (this.getWeaponIndex(0) == 2) {
                if (!this.cannotFireCoax) {
                    Matrix4f transform = this.getBarrelTransform(1.0f);
                    Vector4f worldPosition = this.transformPosition(transform, 0.57f, 0.17f, 0.54f);
                    if ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || hasCreativeAmmo) {
                        ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create(living).setGunItemId(this.m_6095_().m_20675_() + ".1");
                        projectileRight.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                        projectileRight.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                        this.m_9236_().m_7967_((Entity)projectileRight);
                        if (!hasCreativeAmmo) {
                            ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                                    return Ammo.HEAVY.get(stack) > 0;
                                }
                                return false;
                            }).findFirst().orElse(ItemStack.f_41583_);
                            if (!ammoBox.m_41619_()) {
                                Ammo.HEAVY.add(ammoBox, -1);
                            } else {
                                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                            }
                        }
                    }
                    this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 4));
                    this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
                    this.playShootSound3p(living, 0, 4, 12, 24, new Vec3(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_));
                }
            } else if (this.getWeaponIndex(0) == 3) {
                if (this.cannotFire) {
                    return;
                }
                if ((Integer)this.f_19804_.m_135370_(AMMO) <= 0 && !hasCreativeAmmo) {
                    return;
                }
                SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create(living);
                smallCannonShell.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                smallCannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, this.projectileVelocity((Entity)living), 0.25f);
                this.m_9236_().m_7967_((Entity)smallCannonShell);
                this.playShootSound3p(living, 0, 4, 12, 24, this.getTurretShootPos((Entity)living, 1.0f));
                this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)5);
                this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 7));
                this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
                if (!hasCreativeAmmo) {
                    this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> {
                        stack.m_41774_(1);
                        this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
                    });
                }
            }
        }
    }

    public void travel() {
        this.trackEngine(true, 0.052, (Integer)VehicleConfig.BMP_2_ENERGY_COST.get(), 2.5, 0.8, 3.0, 0.8, 0.8f, -0.3f, 0.0033f, 0.002f, 0.12f);
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        if (this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.YX_100_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return org.joml.Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformVehicle = this.getVehicleTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.71f, -0.72f, 0.83f);
            case 1 -> this.transformPosition(transform, 0.5f, 0.0f, -0.8125f);
            case 2, 3, 4, 5, 6 -> this.transformPosition(transformVehicle, 0.5f, 0.0f, -0.8125f);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.71f, 0.7f, 0.83f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public int getMaxPassengers() {
        return 7;
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getGunnerVector(float pPartialTicks) {
        Matrix4f transform = this.getGunnerBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.2f, 0.3f, 0.8158f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.1724f, 2.18f, -0.93f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getGunTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.2f, 0.3f, -0.81f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.gunYRotO, (float)this.getGunYRot()) - Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformT;
    }

    public Matrix4f getGunnerBarrelTransform(float ticks) {
        Matrix4f transformG = this.getGunTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.3598437f, 0.0551625f);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.gunXRotO, (float)this.getGunXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformG.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformG;
    }

    public float rotateYOffset() {
        return 0.5f;
    }

    public void destroy() {
        if (this.m_9236_() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this.getAttacker(), (Entity)this.getAttacker()), 200.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), 16.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
            explosion.m_46061_();
            ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion);
            explosion.m_46075_(false);
            ParticleTool.spawnHugeExplosionParticles((Level)this.m_9236_(), (Vec3)this.m_20182_());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity.m_9236_().f_46443_ && entity == this.m_146895_()) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -60.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 7.0f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getBarrelYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-20.0f, (float)20.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(this.getBarrelYRot(1.0f));
            }
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState cannonShootPredicate(AnimationState<ZBD04AEntity> event) {
        if (this.getWeaponIndex(0) >= 3 && (Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("zbd04a.animation.subcannon.new"));
        }
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0 && this.getWeaponIndex(0) <= 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("zbd04a.animation.minecannon.new"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.unknown.new"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::cannonShootPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
                return 10;
            }
            if (this.getWeaponIndex(0) == 2) {
                return 750;
            }
            if (this.getWeaponIndex(0) == 3) {
                return 250;
            }
        }
        return 10;
    }

    public boolean canShoot(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0;
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.f_19804_.m_135370_(LOADED_HE) > 0;
            }
            if (this.getWeaponIndex(0) == 2) {
                return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
            }
            if (this.getWeaponIndex(0) == 3) {
                return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFire;
            }
        }
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE);
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.f_19804_.m_135370_(LOADED_HE);
            }
            if (this.getWeaponIndex(0) == 2) {
                return (Integer)this.f_19804_.m_135370_(MG_AMMO);
            }
            if (this.getWeaponIndex(0) == 3) {
                return (Integer)this.f_19804_.m_135370_(AMMO);
            }
        }
        return 0;
    }

    public int zoomFov() {
        return 3;
    }

    public boolean banHand(LivingEntity entity) {
        return true;
    }

    public boolean hidePassenger(int index) {
        return true;
    }

    public boolean hasTracks() {
        return true;
    }

    public int getWeaponHeat(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public void changeWeapon(int index, int value, boolean isScroll) {
        int typeIndex;
        if (index != 0) {
            return;
        }
        List weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int n = typeIndex = isScroll ? (value + this.getWeaponIndex(index) + count) % count : value;
        if (typeIndex == 0 || typeIndex == 1) {
            Player player;
            Entity entity;
            if ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0 && typeIndex == 1) {
                entity = this.m_146895_();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity))) {
                    this.insertItem((Item)ModItems.WIRE_GUIDE_MISSILE.get(), 1);
                }
                this.f_19804_.m_135381_(LOADED_MISSILE, (Object)0);
            }
            if ((Integer)this.f_19804_.m_135370_(LOADED_HE) > 0 && typeIndex == 0) {
                entity = this.m_146895_();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity))) {
                    this.insertItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
                this.f_19804_.m_135381_(LOADED_HE, (Object)0);
            }
            if (typeIndex != (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE)) {
                this.reloadCoolDown = 80;
                this.m_20088_().m_135381_(RELOAD_COOLDOWN, (Object)this.reloadCoolDown);
            }
        }
        super.changeWeapon(index, value, isScroll);
    }

    public boolean hasPassengerTurretWeapon() {
        return false;
    }

    public Vec3 getGunVec(float ticks) {
        return this.getGunnerVector(ticks);
    }

    public ResourceLocation getVehicleIcon() {
        return new ResourceLocation("dragonrise", "textures/vehicle_icon/zbd04a_icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        float minWH = org.joml.Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int seatIndex = this.getSeatIndex((Entity)player);
        if (seatIndex == 0) {
            if (this.getWeapon((int)0).mainGun) {
                RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc("textures/hud/cn_tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
            } else {
                RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc("textures/hud/cn_tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
            }
        } else if (seatIndex == 1) {
            RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)com.atsuishio.superbwarfare.Mod.loc((String)"textures/screens/land/lav_gun_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH);
        }
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("APS03 ATGM  " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("3OF70 HE  " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 2) {
            heat = (Integer)this.m_20088_().m_135370_(COAX_HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 5.8MM MG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 3) {
            heat = (Integer)this.m_20088_().m_135370_(HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 30MM DTY02-30 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        }
        float coolDown = (float)((Integer)this.m_20088_().m_135370_(RELOAD_COOLDOWN)).intValue() / 20.0f;
        long currentTime = this.m_9236_().m_46467_();
        if (coolDown <= 0.0f && (Integer)this.m_20088_().m_135370_(RELOAD_COOLDOWN) == 0) {
            if (this.reloadCompleteTime == 0L) {
                this.reloadCompleteTime = currentTime;
            }
            if (currentTime - this.reloadCompleteTime < 20L) {
                guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)"\u88c5\u586b\u5b8c\u6210"), screenWidth / 2 - 17, screenHeight / 2 + 40, 65280, false);
            }
        } else {
            this.reloadCompleteTime = 0L;
            if (coolDown > 0.0f) {
                guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("\u88c5\u586b  " + String.format("%.1f", Float.valueOf(coolDown)))), screenWidth / 2 - 20, screenHeight / 2 + 40, 0xFF0000, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("APS03 ATGM " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("3OF70 HE " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("5.8MM MG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 3) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("30MM ZPL02 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        }
        int coolDown = (Integer)this.m_20088_().m_135370_(RELOAD_COOLDOWN);
        if (coolDown > 0) {
            float coolDownSeconds = (float)coolDown / 20.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("\u88c5\u586b " + String.format("%.1f", Float.valueOf(coolDownSeconds)))), 30, -25, 0xFFFFFF, false);
        }
    }

    public boolean hasDecoy() {
        return true;
    }

    public void releaseSmokeDecoy(Vec3 vec3) {
        if (this.decoyInputDown) {
            if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) > 0 && this.m_9236_() instanceof ServerLevel) {
                Entity passenger = this.m_146895_();
                for (int i = 0; i < 8; ++i) {
                    SmokeDecoyEntity smokeDecoyEntity = new SmokeDecoyEntity((LivingEntity)passenger, this.m_9236_());
                    smokeDecoyEntity.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
                    smokeDecoyEntity.decoyShoot((Entity)this, vec3.m_82524_((-78.75f + 22.5f * (float)i) * ((float)Math.PI / 180)), 4.0f, 8.0f);
                    this.m_9236_().m_7967_((Entity)smokeDecoyEntity);
                }
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_FIRE.get(), this.m_5720_(), 1.0f, 1.0f);
                this.decoyReloadCoolDown = 500;
                this.m_20088_().m_135381_(DECOY_COUNT, (Object)((Integer)this.m_20088_().m_135370_(DECOY_COUNT) - 1));
            }
            this.decoyInputDown = false;
        }
        if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) < 5 && this.decoyReloadCoolDown == 0 && this.m_9236_() instanceof ServerLevel) {
            this.f_19804_.m_135381_(DECOY_COUNT, (Object)((Integer)this.f_19804_.m_135370_(DECOY_COUNT) + 1));
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
            this.decoyReloadCoolDown = 500;
        }
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        if (seatIndex == 0) {
            return zoom ? 0.17 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.22 : 0.35);
        }
        if (seatIndex == 1) {
            return zoom ? 0.25 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.35 : 0.4);
        }
        return original;
    }

    public boolean isEnclosed(int index) {
        return index != 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-ZBD04AEntity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-ZBD04AEntity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            if (this.getSeatIndex((Entity)player) >= 1 && this.getSeatIndex((Entity)player) <= 6) {
                return new Vec2(player.m_146908_(), player.m_146909_());
            }
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_ + (double)0.114f, this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            if (this.getSeatIndex((Entity)player) >= 1 && this.getSeatIndex((Entity)player) <= 6) {
                Matrix4f transform = this.getVehicleTransform(partialTicks);
                Vector4f worldPosition = this.transformPosition(transform, 0.0f, 4.0f, -3.0f);
                return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            }
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return com.atsuishio.superbwarfare.Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public float getTurretMaxHealth() {
        return 150.0f;
    }

    public float getWheelMaxHealth() {
        return 100.0f;
    }

    public float getEngineMaxHealth() {
        return 100.0f;
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obbTurret);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.37f, -1.12f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.28f, 3.0f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.65f, 0.843f, -0.74f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.65f, 0.843f, -0.74f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition5 = this.transformPosition(transform, -0.84f, 1.67f, 1.28f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.36875f, 0.5f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }
}

