/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.modernwarfare.dragonrise.entity.ZHI10MEEntity;
import com.modernwarfare.dragonrise.init.ModEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AKD9Entity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(AKD9Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier();
    private float damage = 250.0f;
    private float explosionDamage = 200.0f;
    private float explosionRadius = 10.0f;
    private float gravity = 0.0f;
    public UUID launcherVehicle;

    public AKD9Entity(EntityType<? extends AKD9Entity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public AKD9Entity(LivingEntity entity, Level level, float damage, float explosionDamage, float explosionRadius) {
        this((EntityType<? extends AKD9Entity>)((EntityType)ModEntities.AKD9.get()), level);
        this.m_5602_((Entity)entity);
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.durability = 50;
    }

    public AKD9Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends AKD9Entity>)((EntityType)ModEntities.AKD9.get()), world);
    }

    public static AKD9Entity create(LivingEntity player) {
        return new AKD9Entity(player, player.m_9236_(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue());
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(10.0f));
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("Damage")) {
            this.damage = compound.m_128457_("Damage");
        }
        if (compound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = compound.m_128457_("ExplosionDamage");
        }
        if (compound.m_128441_("Radius")) {
            this.explosionRadius = compound.m_128457_("Radius");
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128350_("Damage", this.damage);
        compound.m_128350_("ExplosionDamage", this.explosionDamage);
        compound.m_128350_("Radius", this.explosionRadius);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.WIRE_GUIDE_MISSILE.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork((int)3, () -> ((AKD9Entity)this).m_146870_());
                    }
                    this.m_9236_().m_46961_(resultPos, true);
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage((Entity)entity, (DamageSource)ModDamageTypes.causeProjectileHitDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    public void causeExplode(Vec3 vec3) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).withParticleType(ParticleTool.ParticleType.HUGE).explode();
    }

    public void largeTrail() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1) {
            double l = this.m_20184_().m_82553_();
            for (double i = 0.0; i < l; i += 2.0) {
                Vec3 startPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(-i));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        this.largeTrail();
        if (this.f_19797_ == 1 && !this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)this.f_19854_, (double)this.f_19855_, (double)this.f_19856_, (int)15, (double)0.8, (double)0.8, (double)0.8, (double)0.01, (boolean)true);
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123777_, (double)this.f_19854_, (double)this.f_19855_, (double)this.f_19856_, (int)10, (double)0.8, (double)0.8, (double)0.8, (double)0.01, (boolean)true);
        }
        if (this.f_19797_ > 2) {
            this.m_20256_(this.m_20184_().m_82542_(1.03, 1.03, 1.03));
        }
        if (this.f_19797_ > 3 && this.m_19749_() != null && this.launcherVehicle != null) {
            Entity vehicleEntity = null;
            Level level2 = this.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                vehicleEntity = serverLevel.m_8791_(this.launcherVehicle);
            }
            if (vehicleEntity instanceof ZHI10MEEntity) {
                ZHI10MEEntity helicopter = (ZHI10MEEntity)vehicleEntity;
                Entity gunner = helicopter.getNthEntity(1);
                Vec3 eyePos = helicopter.getGunnerEyePosition(1.0f);
                Vec3 lookVec = helicopter.getGunnerVector(1.0f).m_82541_();
                Vec3 toVec = this.m_20184_().m_82541_();
                BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(eyePos, eyePos.m_82549_(lookVec.m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.m_19749_()));
                Vec3 hitPos = result.m_82450_();
                toVec = this.m_20182_().m_82505_(hitPos).m_82541_();
                Mod.LOGGER.info("hitPos: " + String.valueOf(hitPos));
                this.m_20256_(this.m_20184_().m_82549_(toVec.m_82490_(0.8)));
                this.m_20256_(this.m_20184_().m_82542_(0.8, 0.8, 0.8));
            }
        }
        if (this.f_19797_ > 300 || this.m_20069_() || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(this.m_20182_());
            }
            this.m_146870_();
        }
        this.destroyBlock();
    }

    private PlayState movementPredicate(AnimationState<AKD9Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean shouldSyncMotion() {
        return true;
    }

    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.ROCKET_ENGINE.get();
    }

    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    public float getVolume() {
        return 0.4f;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void setLauncherVehicle(UUID uuid) {
        this.launcherVehicle = uuid;
    }

    public boolean forceLoadChunk() {
        return true;
    }

    public static AKD9Entity createWithLauncher(LivingEntity player, UUID launcherVehicle) {
        AKD9Entity missile = new AKD9Entity(player, player.m_9236_(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue(), ((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue());
        missile.setLauncherVehicle(launcherVehicle);
        return missile;
    }
}

