/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.modernwarfare.dragonrise.Mod;
import com.modernwarfare.dragonrise.config.IConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHandler<T extends IConfig> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> configType;
    private final Path configPath;
    private T config;
    private int configHash;

    public static <T extends IConfig> ConfigHandler<T> of(Class<T> configType, String configExtension) {
        return new ConfigHandler<T>(configType, FMLPaths.CONFIGDIR.get().resolve("dragonrise" + configExtension));
    }

    public ConfigHandler(Class<T> configType, Path configPath) {
        this.configType = configType;
        this.configPath = configPath;
        this.configHash = 0;
        try {
            this.config = (IConfig)configType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            System.err.println("\u914d\u7f6e\u7c7b\u7f3a\u5c11\u65e0\u53c2\u6784\u9020\u51fd\u6570: " + e.getMessage());
            throw new RuntimeException("\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            System.err.println("\u521b\u5efa\u914d\u7f6e\u5b9e\u4f8b\u5931\u8d25: " + e.getMessage());
            throw new RuntimeException("\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public void save() {
        if (this.configHash == this.config.hashCode()) {
            return;
        }
        this.config.onUpdate();
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                Mod.LOGGER.error("Creating Config failed: " + String.valueOf(e));
                return;
            }
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);
            this.gson.toJson(this.config, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            Mod.LOGGER.error("Saving Config failed: " + String.valueOf(e));
            return;
        }
        this.configHash = this.config.hashCode();
        Mod.LOGGER.info("Saved " + String.valueOf(this.config));
    }

    public void load() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(this.configPath);
            this.config = (IConfig)this.gson.fromJson((Reader)reader, this.configType);
            reader.close();
        }
        catch (Exception e) {
            this.config = null;
        }
        if (this.config == null) {
            try {
                this.config = (IConfig)this.configType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.println("\u914d\u7f6e\u7c7b\u7f3a\u5c11\u65e0\u53c2\u6784\u9020\u51fd\u6570: " + e.getMessage());
                throw new RuntimeException("\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                System.err.println("\u521b\u5efa\u914d\u7f6e\u5b9e\u4f8b\u5931\u8d25: " + e.getMessage());
                throw new RuntimeException("\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25", e);
            }
            Mod.LOGGER.error("Config is broken -> reset to defaults");
            this.save();
            return;
        }
        this.config.validate();
        this.configHash = this.config.hashCode();
        Mod.LOGGER.info("Loaded " + String.valueOf(this.config));
    }

    public T getConfig() {
        return this.config;
    }
}

