/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.modernwarfare.dragonrise.entity.ZTZ99AEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class ZTZ99AMgHudOverlay
implements IGuiOverlay {
    public static final String ID = "dragonrise_ztz99a_mg_hud";
    private static final ResourceLocation MG_CROSSHAIR = new ResourceLocation("superbwarfare", "textures/screens/cannon/cannon_crosshair_notzoom.png");
    private static final ResourceLocation DRONE_ICON = new ResourceLocation("superbwarfare", "textures/screens/drone.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (!this.shouldRenderCrossHair((Player)player)) {
            return;
        }
        ZTZ99AEntity ztz99a = (ZTZ99AEntity)player.m_20202_();
        if (ztz99a == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        this.setupRenderState();
        if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            this.renderFirstPersonCrosshair(guiGraphics, screenWidth, screenHeight, ztz99a, (Player)player);
        } else if (mc.f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK) {
            this.renderThirdPersonCrosshair(guiGraphics, ztz99a, (Player)player, partialTick);
        }
        poseStack.m_85849_();
        this.restoreRenderState();
    }

    private void renderFirstPersonCrosshair(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ZTZ99AEntity ztz99a, Player player) {
        float fovAdjust = this.calculateFovAdjustment();
        float minDimension = Math.min(screenWidth, screenHeight);
        float adjustedSize = Math.min((float)screenWidth / minDimension, (float)screenHeight / minDimension) * fovAdjust;
        int renderSize = Mth.m_14143_((float)(minDimension * adjustedSize));
        int xPos = (screenWidth - renderSize) / 2;
        int yPos = (screenHeight - renderSize) / 2;
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)MG_CROSSHAIR, (float)xPos, (float)yPos, (float)0.0f, (float)0.0f, (float)renderSize, (float)renderSize, (float)renderSize, (float)renderSize);
        this.renderWeaponStatus(guiGraphics, screenWidth, screenHeight, ztz99a, player);
    }

    private void renderThirdPersonCrosshair(GuiGraphics guiGraphics, ZTZ99AEntity ztz99a, Player player, float partialTick) {
        Vec3 targetPos = this.calculateTargetPosition(ztz99a, player, partialTick);
        Vec3 screenPos = VectorUtil.worldToScreen((Vec3)targetPos);
        if (VectorUtil.canSee((Vec3)targetPos)) {
            this.renderThirdPersonCrosshairAtPosition(guiGraphics, screenPos, ztz99a, player);
        }
    }

    private void renderThirdPersonCrosshairAtPosition(GuiGraphics guiGraphics, Vec3 screenPos, ZTZ99AEntity ztz99a, Player player) {
        float x = (float)screenPos.f_82479_;
        float y = (float)screenPos.f_82480_;
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)DRONE_ICON, (float)(x - 12.0f), (float)(y - 12.0f), (float)0.0f, (float)0.0f, (float)24.0f, (float)24.0f, (float)24.0f, (float)24.0f);
        this.renderThirdPersonWeaponInfo(guiGraphics, x, y, ztz99a, player);
    }

    private float calculateFovAdjustment() {
        return 70.0f / (float)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
    }

    private Vec3 calculateTargetPosition(ZTZ99AEntity ztz99a, Player player, float partialTick) {
        Vec3 shootPos = ztz99a.passengerWeaponShootPos((Entity)player, partialTick);
        Vec3 aimVector = ztz99a.getGunVec(partialTick);
        return shootPos.m_82549_(aimVector.m_82490_(192.0));
    }

    private void renderWeaponStatus(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ZTZ99AEntity ztz99a, Player player) {
        int heat = (Integer)ztz99a.m_20088_().m_135370_(ZTZ99AEntity.HEAT);
        if (heat > 0) {
            float heatPercent = (float)heat / 100.0f;
            this.renderVerticalHeatBar(guiGraphics, screenWidth, screenHeight, heatPercent);
        }
    }

    private void renderVerticalHeatBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float heatPercent) {
        int barWidth = 3;
        int barHeight = 80;
        int margin = 20;
        int x = screenWidth - margin - barWidth;
        int y = screenHeight / 2 - barHeight / 2;
        guiGraphics.m_280509_(x, y, x + barWidth, y + barHeight, Integer.MIN_VALUE);
        int heatHeight = (int)((float)barHeight * heatPercent);
        int heatColor = Mth.m_14169_((float)0.0f, (float)heatPercent, (float)1.0f);
        guiGraphics.m_280509_(x, y + barHeight - heatHeight, x + barWidth, y + barHeight, heatColor | 0xFF000000);
    }

    private void renderThirdPersonWeaponInfo(GuiGraphics guiGraphics, float x, float y, ZTZ99AEntity ztz99a, Player player) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        poseStack.m_85849_();
    }

    private void setupRenderState() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void restoreRenderState() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    private boolean shouldRenderCrossHair(Player player) {
        ZTZ99AEntity ztz99a;
        if (player == null) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        Entity entity = player.m_20202_();
        return entity instanceof ZTZ99AEntity && (ztz99a = (ZTZ99AEntity)entity).getNthEntity(1) == player;
    }
}

