/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.modernwarfare.dragonrise.entity.ZHI10MEEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class Z10MEOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_helicopter_hud";
    private static final ResourceLocation CANNON_CROSSHAIR = new ResourceLocation("superbwarfare", "textures/screens/cannon/hpj_crosshair_notzoom.png");
    private static final ResourceLocation MISSILE_CROSSHAIR = new ResourceLocation("dragonrise", "textures/hud/z10_missile_crosshair.png");
    private static final ResourceLocation HELI_BASE = new ResourceLocation("superbwarfare", "textures/screens/helicopter/heli_base.png");
    private static final ResourceLocation COMPASS = new ResourceLocation("superbwarfare", "textures/screens/compass.png");
    private static final ResourceLocation HELI_LINE = new ResourceLocation("superbwarfare", "textures/screens/helicopter/heli_line.png");
    private static final ResourceLocation ROLL_IND = new ResourceLocation("superbwarfare", "textures/screens/helicopter/roll_ind.png");
    private static final ResourceLocation SPEED_FRAME = new ResourceLocation("superbwarfare", "textures/screens/helicopter/speed_frame.png");
    private static final ResourceLocation DRIVER_ANGLE = new ResourceLocation("superbwarfare", "textures/screens/helicopter/heli_driver_angle.png");
    private static float scopeScale = 1.0f;
    private static final int HUD_COLOR = -16711936;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ZHI10MEEntity zhi10mea;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof ZHI10MEEntity && (zhi10mea = (ZHI10MEEntity)entity).getNthEntity(1) == player) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            this.setupRenderState();
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                this.renderHelicopterHUD(guiGraphics, screenWidth, screenHeight, zhi10mea, (Player)player, partialTick, true);
            } else if (mc.f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK) {
                this.renderHelicopterHUD(guiGraphics, screenWidth, screenHeight, zhi10mea, (Player)player, partialTick, false);
            }
            poseStack.m_85849_();
            this.restoreRenderState();
        } else {
            scopeScale = 0.7f;
        }
    }

    private void renderHelicopterHUD(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ZHI10MEEntity zhi10mea, Player player, float partialTick, boolean isFirstPerson) {
        PoseStack poseStack = guiGraphics.m_280168_();
        scopeScale = Mth.m_14179_((float)partialTick, (float)scopeScale, (float)1.0f);
        float minDimension = Math.min(screenWidth, screenHeight);
        float adjustedSize = Math.min((float)screenWidth / minDimension, (float)screenHeight / minDimension) * scopeScale;
        int renderSize = Mth.m_14143_((float)(minDimension * adjustedSize));
        int xPos = (screenWidth - renderSize) / 2;
        int yPos = (screenHeight - renderSize) / 2;
        ResourceLocation crosshairTexture = this.getCrosshairTexture(zhi10mea, isFirstPerson);
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)crosshairTexture, (float)xPos, (float)yPos, (float)0.0f, (float)0.0f, (float)renderSize, (float)renderSize, (float)renderSize, (float)renderSize);
        this.renderWeaponStatus(guiGraphics, screenWidth, screenHeight, zhi10mea, player);
        Z10MEOverlay.renderKillIndicator(guiGraphics, (float)screenWidth / 2.0f - 7.5f, (float)screenHeight / 2.0f - 7.5f);
        this.renderGunnerAngle(guiGraphics, player, (Entity)zhi10mea, xPos, yPos, renderSize, renderSize, partialTick);
        this.renderPowerAndSpeedInfo(guiGraphics, screenWidth, screenHeight, zhi10mea, partialTick);
    }

    private ResourceLocation getCrosshairTexture(ZHI10MEEntity zhi10mea, boolean isFirstPerson) {
        if (isFirstPerson) {
            return CANNON_CROSSHAIR;
        }
        int weaponIndex = zhi10mea.getWeaponIndex(1);
        return weaponIndex == 1 ? MISSILE_CROSSHAIR : CANNON_CROSSHAIR;
    }

    private void renderWeaponStatus(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ZHI10MEEntity zhi10mea, Player player) {
        int heat = (Integer)zhi10mea.m_20088_().m_135370_(VehicleEntity.HEAT);
        if (heat > 0) {
            float heatPercent = (float)heat / 100.0f;
            this.renderVerticalHeatBar(guiGraphics, screenWidth, screenHeight, heatPercent);
        }
    }

    private void renderVerticalHeatBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float heatPercent) {
        int barWidth = 3;
        int barHeight = 80;
        int margin = 20;
        int x = screenWidth - margin - barWidth;
        int y = screenHeight / 2 - barHeight / 2;
        guiGraphics.m_280509_(x, y, x + barWidth, y + barHeight, -1);
        int heatHeight = (int)((float)barHeight * heatPercent);
        int heatColor = Mth.m_14169_((float)0.0f, (float)heatPercent, (float)1.0f);
        guiGraphics.m_280509_(x, y + barHeight - heatHeight, x + barWidth, y + barHeight, heatColor | 0xFF000000);
    }

    private void renderGunnerAngle(GuiGraphics guiGraphics, Player player, Entity heli, float k, float l, float i, float j, float ticks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float diffY = Mth.m_14177_((float)(Mth.m_14179_((float)ticks, (float)player.f_20886_, (float)player.m_6080_()) - Mth.m_14179_((float)ticks, (float)heli.f_19859_, (float)heli.m_146908_()))) * 0.35f;
        float diffX = Mth.m_14177_((float)(Mth.m_14179_((float)ticks, (float)player.f_19860_, (float)player.m_146909_()) - Mth.m_14179_((float)ticks, (float)heli.f_19860_, (float)heli.m_146909_()))) * 0.072f;
        if (heli instanceof ContainerMobileVehicleEntity) {
            ContainerMobileVehicleEntity helic = (ContainerMobileVehicleEntity)heli;
            float gundiffY = Mth.m_14177_((float)Mth.m_14179_((float)ticks, (float)helic.gunYRotO, (float)helic.getGunYRot())) * -0.35f;
            float gundiffX = Mth.m_14177_((float)(Mth.m_14179_((float)ticks, (float)helic.gunXRotO, (float)helic.getGunXRot()) - Mth.m_14179_((float)ticks, (float)heli.f_19860_, (float)heli.m_146909_()))) * 0.072f;
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)DRIVER_ANGLE, (float)(k + gundiffY), (float)(l + gundiffX), (float)0.0f, (float)0.0f, (float)i, (float)j, (float)i, (float)j, (int)-16711936);
        }
        RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)DRIVER_ANGLE, (float)(k + diffY), (float)(l + diffX), (float)0.0f, (float)0.0f, (float)i, (float)j, (float)i, (float)j, (int)-65536);
    }

    private void renderPowerAndSpeedInfo(GuiGraphics guiGraphics, int screenWidth, int screenHeight, ZHI10MEEntity zhi10mea, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)String.valueOf((int)zhi10mea.m_20186_())), screenWidth / 2 + 104, screenHeight / 2, -16711936, false);
        RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)SPEED_FRAME, (float)((float)screenWidth / 2.0f - 144.0f), (float)((float)screenHeight / 2.0f - 6.0f), (float)0.0f, (float)0.0f, (float)50.0f, (float)18.0f, (float)50.0f, (float)18.0f, (int)-16711936);
        double speed = Math.sqrt(zhi10mea.m_20184_().f_82479_ * zhi10mea.m_20184_().f_82479_ + zhi10mea.m_20184_().f_82480_ * zhi10mea.m_20184_().f_82480_ + zhi10mea.m_20184_().f_82481_ * zhi10mea.m_20184_().f_82481_) * 72.0;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)String.format("%.0f km/h", speed)), screenWidth / 2 - 140, screenHeight / 2, -16711936, false);
    }

    private static void renderKillIndicator(GuiGraphics guiGraphics, float posX, float posY) {
        VehicleHudOverlay.renderKillIndicator3P((GuiGraphics)guiGraphics, (float)posX, (float)posY);
    }

    private void setupRenderState() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void restoreRenderState() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }
}

