/*
 * Decompiled with CFR 0.152.
 */
package com.modernwarfare.dragonrise.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.modernwarfare.dragonrise.entity.HYR0Entity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class HYR0MgHudOverlay
implements IGuiOverlay {
    public static final String ID = "dragonrise_hyr0_mg_hud";
    private static final ResourceLocation MG_CROSSHAIR = new ResourceLocation("superbwarfare", "textures/screens/cannon/cannon_crosshair_notzoom.png");
    private static final ResourceLocation DRONE_ICON = new ResourceLocation("superbwarfare", "textures/screens/drone.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (!this.shouldRenderCrossHair((Player)player)) {
            return;
        }
        HYR0Entity hyr0 = (HYR0Entity)player.m_20202_();
        if (hyr0 == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        this.setupRenderState();
        if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            this.renderFirstPersonCrosshair(guiGraphics, screenWidth, screenHeight, hyr0, (Player)player);
        } else if (mc.f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK) {
            this.renderThirdPersonCrosshair(guiGraphics, hyr0, (Player)player, partialTick);
        }
        poseStack.m_85849_();
        this.restoreRenderState();
    }

    private void renderFirstPersonCrosshair(GuiGraphics guiGraphics, int screenWidth, int screenHeight, HYR0Entity hyr0, Player player) {
        float fovAdjust = this.calculateFovAdjustment();
        float minDimension = Math.min(screenWidth, screenHeight);
        float adjustedSize = Math.min((float)screenWidth / minDimension, (float)screenHeight / minDimension) * fovAdjust;
        int renderSize = Mth.m_14143_((float)(minDimension * adjustedSize));
        int xPos = (screenWidth - renderSize) / 2;
        int yPos = (screenHeight - renderSize) / 2;
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)MG_CROSSHAIR, (float)xPos, (float)yPos, (float)0.0f, (float)0.0f, (float)renderSize, (float)renderSize, (float)renderSize, (float)renderSize);
        this.renderWeaponStatus(guiGraphics, screenWidth, screenHeight, hyr0, player);
    }

    private void renderThirdPersonCrosshair(GuiGraphics guiGraphics, HYR0Entity hyr0, Player player, float partialTick) {
        Vec3 targetPos = this.calculateTargetPosition(hyr0, player, partialTick);
        Vec3 screenPos = VectorUtil.worldToScreen((Vec3)targetPos);
        if (VectorUtil.canSee((Vec3)targetPos)) {
            this.renderThirdPersonCrosshairAtPosition(guiGraphics, screenPos, hyr0, player);
        }
    }

    private void renderThirdPersonCrosshairAtPosition(GuiGraphics guiGraphics, Vec3 screenPos, HYR0Entity hyr0, Player player) {
        float x = (float)screenPos.f_82479_;
        float y = (float)screenPos.f_82480_;
        RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)DRONE_ICON, (float)(x - 12.0f), (float)(y - 12.0f), (float)0.0f, (float)0.0f, (float)24.0f, (float)24.0f, (float)24.0f, (float)24.0f);
        this.renderThirdPersonWeaponInfo(guiGraphics, x, y, hyr0, player);
    }

    private float calculateFovAdjustment() {
        return 70.0f / (float)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
    }

    private Vec3 calculateTargetPosition(HYR0Entity hyr0, Player player, float partialTick) {
        Vec3 shootPos = hyr0.passengerWeaponShootPos((Entity)player, partialTick);
        Vec3 aimVector = hyr0.getGunVec(partialTick);
        return shootPos.m_82549_(aimVector.m_82490_(192.0));
    }

    private void renderWeaponStatus(GuiGraphics guiGraphics, int screenWidth, int screenHeight, HYR0Entity hyr0, Player player) {
        int heat = (Integer)hyr0.m_20088_().m_135370_(HYR0Entity.HEAT);
        if (heat > 0) {
            float heatPercent = (float)heat / 100.0f;
            this.renderVerticalHeatBar(guiGraphics, screenWidth, screenHeight, heatPercent);
        }
    }

    private void renderVerticalHeatBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, float heatPercent) {
        int barWidth = 3;
        int barHeight = 80;
        int margin = 20;
        int x = screenWidth - margin - barWidth;
        int y = screenHeight / 2 - barHeight / 2;
        guiGraphics.m_280509_(x, y, x + barWidth, y + barHeight, Integer.MIN_VALUE);
        int heatHeight = (int)((float)barHeight * heatPercent);
        int heatColor = Mth.m_14169_((float)0.0f, (float)heatPercent, (float)1.0f);
        guiGraphics.m_280509_(x, y + barHeight - heatHeight, x + barWidth, y + barHeight, heatColor | 0xFF000000);
    }

    private void renderThirdPersonWeaponInfo(GuiGraphics guiGraphics, float x, float y, HYR0Entity hyr0, Player player) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        poseStack.m_85849_();
    }

    private void setupRenderState() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void restoreRenderState() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    private boolean shouldRenderCrossHair(Player player) {
        HYR0Entity hyr0;
        if (player == null) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        Entity entity = player.m_20202_();
        return entity instanceof HYR0Entity && (hyr0 = (HYR0Entity)entity).getNthEntity(1) == player;
    }
}

