/*
 * Decompiled with CFR 0.152.
 */
package ca.zandercraft.doorknockerforge;

import ca.zandercraft.doorknockerforge.KnockSounds;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="doorknockerforge")
public class DoorKnockerForge {
    public static final String MODID = "doorknockerforge";
    private static final Logger LOGGER = LogUtils.getLogger();

    public DoorKnockerForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        KnockSounds.SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Loading Door Knocker (Forge)...");
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState block = world.m_8055_(pos);
        Player player = event.getEntity();
        if (block.m_60734_() instanceof DoorBlock && player.m_21205_().m_41619_()) {
            world.m_5594_(player, pos, (SoundEvent)KnockSounds.DOOR_KNOCK_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (block.m_60734_() instanceof TrapDoorBlock && player.m_21205_().m_41619_()) {
            world.m_5594_(player, pos, (SoundEvent)KnockSounds.TRAPDOOR_KNOCK_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

