/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.doaddonfluids.registry;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.ninjdai.doaddonfluids.DoAddonExpectPlatform;
import dev.ninjdai.doaddonfluids.DoAddonFluids;
import dev.ninjdai.doaddonfluids.registry.DoAddonFluidProperties;
import earth.terrarium.botarium.common.registry.fluid.BotariumFlowingFluid;
import earth.terrarium.botarium.common.registry.fluid.BotariumSourceFluid;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.Fluid;

public class DoAddonFluid {
    public static final ResourcefulRegistry<Fluid> FLUIDS = ResourcefulRegistries.create((Registry)BuiltInRegistries.f_257020_, (String)"doaddonfluids");

    public static void registerModDependentFluids() {
        if (DoAddonExpectPlatform.isModLoaded("vinery")) {
            DoAddonFluids.LOGGER.info("Vinery found, registering fluids");
            DoAddonFluid.registerVineryFluids();
        }
        if (DoAddonExpectPlatform.isModLoaded("nethervinery")) {
            DoAddonFluids.LOGGER.info("NetherVinery found, registering fluids");
            DoAddonFluid.registerNetherVineryFluids();
        }
        if (DoAddonExpectPlatform.isModLoaded("meadow")) {
            DoAddonFluids.LOGGER.info("Meadow found, registering fluids");
            DoAddonFluid.registerMeadowFluids();
        }
        if (DoAddonExpectPlatform.isModLoaded("herbalbrews")) {
            DoAddonFluids.LOGGER.info("HerbalBrews found, registering fluids");
            DoAddonFluid.registerHerbalBrewsFluids();
        }
        if (DoAddonExpectPlatform.isModLoaded("bakery")) {
            DoAddonFluids.LOGGER.info("Bakery found, registering fluids");
            DoAddonFluid.registerBakeryFluids();
        }
    }

    public static void registerVineryFluids() {
        RegistryEntry RED_GRAPEJUICE = FLUIDS.register("red_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.RED_GRAPEJUICE));
        RegistryEntry RED_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_red_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.RED_GRAPEJUICE));
        RegistryEntry WHITE_GRAPEJUICE = FLUIDS.register("white_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.WHITE_GRAPEJUICE));
        RegistryEntry WHITE_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_white_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.WHITE_GRAPEJUICE));
        RegistryEntry JUNGLE_RED_GRAPEJUICE = FLUIDS.register("jungle_red_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.JUNGLE_RED_GRAPEJUICE));
        RegistryEntry JUNGLE_RED_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_jungle_red_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.JUNGLE_RED_GRAPEJUICE));
        RegistryEntry JUNGLE_WHITE_GRAPEJUICE = FLUIDS.register("jungle_white_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.JUNGLE_WHITE_GRAPEJUICE));
        RegistryEntry JUNGLE_WHITE_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_jungle_white_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.JUNGLE_WHITE_GRAPEJUICE));
        RegistryEntry SAVANNA_RED_GRAPEJUICE = FLUIDS.register("savanna_red_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.SAVANNA_RED_GRAPEJUICE));
        RegistryEntry SAVANNA_RED_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_savanna_red_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.SAVANNA_RED_GRAPEJUICE));
        RegistryEntry SAVANNA_WHITE_GRAPEJUICE = FLUIDS.register("savanna_white_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.SAVANNA_WHITE_GRAPEJUICE));
        RegistryEntry SAVANNA_WHITE_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_savanna_white_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.SAVANNA_WHITE_GRAPEJUICE));
        RegistryEntry TAIGA_RED_GRAPEJUICE = FLUIDS.register("taiga_red_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.TAIGA_RED_GRAPEJUICE));
        RegistryEntry TAIGA_RED_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_taiga_red_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.TAIGA_RED_GRAPEJUICE));
        RegistryEntry TAIGA_WHITE_GRAPEJUICE = FLUIDS.register("taiga_white_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.TAIGA_WHITE_GRAPEJUICE));
        RegistryEntry TAIGA_WHITE_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_taiga_white_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.TAIGA_WHITE_GRAPEJUICE));
    }

    public static void registerNetherVineryFluids() {
        RegistryEntry CRIMSON_GRAPEJUICE = FLUIDS.register("crimson_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.CRIMSON_GRAPEJUICE));
        RegistryEntry CRIMSON_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_crimson_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.CRIMSON_GRAPEJUICE));
        RegistryEntry WARPED_GRAPEJUICE = FLUIDS.register("warped_grapejuice", () -> new BotariumSourceFluid(DoAddonFluidProperties.WARPED_GRAPEJUICE));
        RegistryEntry WARPED_GRAPEJUICE_FLOWING = FLUIDS.register("flowing_warped_grapejuice", () -> new BotariumFlowingFluid(DoAddonFluidProperties.WARPED_GRAPEJUICE));
    }

    public static void registerMeadowFluids() {
        RegistryEntry RENNET = FLUIDS.register("rennet", () -> new BotariumSourceFluid(DoAddonFluidProperties.RENNET));
        RegistryEntry RENNET_FLOWING = FLUIDS.register("flowing_rennet", () -> new BotariumFlowingFluid(DoAddonFluidProperties.RENNET));
        RegistryEntry BUFFALO_MILK = FLUIDS.register("buffalo_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.BUFFALO_MILK));
        RegistryEntry BUFFALO_MILK_FLOWING = FLUIDS.register("flowing_buffalo_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.BUFFALO_MILK));
        RegistryEntry AMETHYST_MILK = FLUIDS.register("amethyst_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.AMETHYST_MILK));
        RegistryEntry AMETHYST_MILK_FLOWING = FLUIDS.register("flowing_amethyst_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.AMETHYST_MILK));
        RegistryEntry GOAT_MILK = FLUIDS.register("goat_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.GOAT_MILK));
        RegistryEntry GOAT_MILK_FLOWING = FLUIDS.register("flowing_goat_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.GOAT_MILK));
        RegistryEntry GRAIN_MILK = FLUIDS.register("grain_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.GRAIN_MILK));
        RegistryEntry GRAIN_MILK_FLOWING = FLUIDS.register("flowing_grain_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.GRAIN_MILK));
        RegistryEntry SHEEP_MILK = FLUIDS.register("sheep_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.SHEEP_MILK));
        RegistryEntry SHEEP_MILK_FLOWING = FLUIDS.register("flowing_sheep_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.SHEEP_MILK));
        RegistryEntry WARPED_MILK = FLUIDS.register("warped_milk", () -> new BotariumSourceFluid(DoAddonFluidProperties.WARPED_MILK));
        RegistryEntry WARPED_MILK_FLOWING = FLUIDS.register("flowing_warped_milk", () -> new BotariumFlowingFluid(DoAddonFluidProperties.WARPED_MILK));
    }

    public static void registerHerbalBrewsFluids() {
        RegistryEntry GREEN_TEA = FLUIDS.register("green_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.GREEN_TEA));
        RegistryEntry GREEN_TEA_FLOWING = FLUIDS.register("flowing_green_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.GREEN_TEA));
        RegistryEntry BLACK_TEA = FLUIDS.register("black_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.BLACK_TEA));
        RegistryEntry BLACK_TEA_FLOWING = FLUIDS.register("flowing_black_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.BLACK_TEA));
        RegistryEntry HIBISCUS_TEA = FLUIDS.register("hibiscus_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.HIBISCUS_TEA));
        RegistryEntry HIBISCUS_TEA_FLOWING = FLUIDS.register("flowing_hibiscus_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.HIBISCUS_TEA));
        RegistryEntry LAVENDER_TEA = FLUIDS.register("lavender_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.LAVENDER_TEA));
        RegistryEntry LAVENDER_TEA_FLOWING = FLUIDS.register("flowing_lavender_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.LAVENDER_TEA));
        RegistryEntry YERBA_MATE_TEA = FLUIDS.register("yerba_mate_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.YERBA_MATE_TEA));
        RegistryEntry YERBA_MATE_TEA_FLOWING = FLUIDS.register("flowing_yerba_mate_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.YERBA_MATE_TEA));
        RegistryEntry ROOIBOS_TEA = FLUIDS.register("rooibos_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.ROOIBOS_TEA));
        RegistryEntry ROOIBOS_TEA_FLOWING = FLUIDS.register("flowing_rooibos_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.ROOIBOS_TEA));
        RegistryEntry OOLONG_TEA = FLUIDS.register("oolong_tea", () -> new BotariumSourceFluid(DoAddonFluidProperties.OOLONG_TEA));
        RegistryEntry OOLONG_TEA_FLOWING = FLUIDS.register("flowing_oolong_tea", () -> new BotariumFlowingFluid(DoAddonFluidProperties.OOLONG_TEA));
        RegistryEntry COFFEE = FLUIDS.register("coffee", () -> new BotariumSourceFluid(DoAddonFluidProperties.COFFEE));
        RegistryEntry COFFEE_FLOWING = FLUIDS.register("flowing_coffee", () -> new BotariumFlowingFluid(DoAddonFluidProperties.COFFEE));
        RegistryEntry MILK_COFFEE = FLUIDS.register("milk_coffee", () -> new BotariumSourceFluid(DoAddonFluidProperties.MILK_COFFEE));
        RegistryEntry MILK_COFFEE_FLOWING = FLUIDS.register("flowing_milk_coffee", () -> new BotariumFlowingFluid(DoAddonFluidProperties.MILK_COFFEE));
    }

    public static void registerBakeryFluids() {
        RegistryEntry STRAWBERRY_JAM = FLUIDS.register("strawberry_jam", () -> new BotariumSourceFluid(DoAddonFluidProperties.STRAWBERRY_JAM));
        RegistryEntry STRAWBERRY_JAM_FLOWING = FLUIDS.register("flowing_strawberry_jam", () -> new BotariumFlowingFluid(DoAddonFluidProperties.STRAWBERRY_JAM));
        RegistryEntry GLOWBERRY_JAM = FLUIDS.register("glowberry_jam", () -> new BotariumSourceFluid(DoAddonFluidProperties.GLOWBERRY_JAM));
        RegistryEntry GLOWBERRY_JAM_FLOWING = FLUIDS.register("flowing_glowberry_jam", () -> new BotariumFlowingFluid(DoAddonFluidProperties.GLOWBERRY_JAM));
        RegistryEntry SWEETBERRY_JAM = FLUIDS.register("sweetberry_jam", () -> new BotariumSourceFluid(DoAddonFluidProperties.SWEETBERRY_JAM));
        RegistryEntry SWEETBERRY_JAM_FLOWING = FLUIDS.register("flowing_sweetberry_jam", () -> new BotariumFlowingFluid(DoAddonFluidProperties.SWEETBERRY_JAM));
        RegistryEntry APPLE_JAM = FLUIDS.register("apple_jam", () -> new BotariumSourceFluid(DoAddonFluidProperties.APPLE_JAM));
        RegistryEntry APPLE_JAM_FLOWING = FLUIDS.register("flowing_apple_jam", () -> new BotariumFlowingFluid(DoAddonFluidProperties.APPLE_JAM));
    }
}

