/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.computercraft;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import site.siredvin.digitalitems.common.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.DigitizedItem;
import site.siredvin.digitalitems.common.blockentity.DigitizerBlockEntity;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.peripheralium.extra.plugins.InventoryPlugin;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006$"}, d2={"Lsite/siredvin/digitalitems/computercraft/DigitizerPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BlockEntityPeripheralOwner;", "Lsite/siredvin/digitalitems/common/blockentity/DigitizerBlockEntity;", "blockEntity", "(Lsite/siredvin/digitalitems/common/blockentity/DigitizerBlockEntity;)V", "decayEnabled", "", "getDecayEnabled", "()Z", "decayTicks", "", "getDecayTicks", "()J", "isEnabled", "checkID", "Lsite/siredvin/digitalitems/common/DigitizedItem;", "sd", "Lsite/siredvin/digitalitems/common/DigitalItemsSavedData;", "id", "Ljava/nio/ByteBuffer;", "digitize", "", "digitizeAmount", "amount", "", "getIDInfo", "", "", "", "getType", "refresh", "", "rematerialize", "rematerializeAmount", "Companion", "digitalitems-forge-1.20.1"})
public final class DigitizerPeripheral
extends OwnedPeripheral<BlockEntityPeripheralOwner<DigitizerBlockEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DigitizerBlockEntity blockEntity;
    @NotNull
    private static final SecureRandom rand = new SecureRandom();
    @NotNull
    public static final String TYPE = "digitizer";

    public DigitizerPeripheral(@NotNull DigitizerBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(TYPE, (IPeripheralOwner)new BlockEntityPeripheralOwner((BlockEntity)blockEntity, null, 2, null));
        this.blockEntity = blockEntity;
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        this.addPlugin((IPeripheralPlugin)new InventoryPlugin(level, (SlottedItemStorage)this.blockEntity.getStorage()));
    }

    private final DigitizedItem checkID(DigitalItemsSavedData sd, ByteBuffer id) throws LuaException {
        DigitizedItem item;
        block3: {
            block2: {
                item = sd.get(id);
                if (item == null) break block2;
                Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
                Intrinsics.checkNotNull((Object)level);
                if (!item.decayed(level)) break block3;
            }
            sd.pop(id);
            throw new LuaException("Invalid item ID");
        }
        return item;
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    @LuaFunction(mainThread=true)
    public final boolean getDecayEnabled() {
        return ModConfig.INSTANCE.getEnableDecay();
    }

    @LuaFunction(mainThread=true)
    public final long getDecayTicks() {
        return ModConfig.INSTANCE.getDecayTicks();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final byte[] digitize() throws LuaException {
        return this.digitizeAmount(this.blockEntity.getStorage().getItem(0).m_41613_());
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final byte[] digitizeAmount(int amount) throws LuaException {
        ItemStack item = this.blockEntity.getStorage().getItem(0);
        if (amount <= 0) {
            throw new LuaException("Invalid amount");
        }
        if (item.m_41613_() < amount) {
            throw new LuaException("Fewer items present than requested for digitization");
        }
        byte[] id = new byte[16];
        rand.nextBytes(id);
        Level level = this.blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData data = DigitalItemsSavedData.Companion.getFrom(level);
        ItemStack itemStack = this.blockEntity.getStorage().takeItems(amount, 0, 0, ItemStorageUtils.INSTANCE.getALWAYS()).m_41777_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"blockEntity.storage.take\u2026orageUtils.ALWAYS).copy()");
        Level level2 = this.blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level2);
        DigitizedItem digitizedItem = new DigitizedItem(id, itemStack, level2.m_46467_());
        data.add(digitizedItem);
        data.m_77762_();
        return id;
    }

    @LuaFunction(mainThread=true)
    public final int rematerialize(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = this.blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level);
        DigitizedItem item = this.checkID(sd, id);
        return this.rematerializeAmount(id, item.getItem().m_41613_());
    }

    @LuaFunction(mainThread=true)
    public final int rematerializeAmount(@NotNull ByteBuffer id, int amount) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = this.blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level);
        DigitizedItem item = this.checkID(sd, id);
        if (amount <= 0) {
            throw new LuaException("Invalid amount");
        }
        if (item.getItem().m_41613_() < amount) {
            throw new LuaException("Fewer items present in ID than requested for rematerialization");
        }
        ItemStack itemStack = item.getItem().m_41777_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"item.item.copy()");
        ItemStack limitedAmount = itemStack;
        limitedAmount.m_41764_(amount);
        ItemStack remaining = this.blockEntity.getStorage().storeItem(limitedAmount);
        item.getItem().m_41764_(item.getItem().m_41613_() - (limitedAmount.m_41613_() - remaining.m_41613_()));
        if (item.getItem().m_41613_() == 0) {
            sd.pop(id);
        } else {
            Level level2 = this.blockEntity.m_58904_();
            Intrinsics.checkNotNull((Object)level2);
            item.refresh(level2.m_46467_());
            sd.m_77762_();
        }
        sd.m_77762_();
        return limitedAmount.m_41613_() - remaining.m_41613_();
    }

    @LuaFunction(mainThread=true)
    public final void refresh(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level2);
        DigitizedItem item = this.checkID(sd, id);
        long currentTime = level2.m_46467_();
        item.refresh(currentTime);
        sd.m_77762_();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getIDInfo(@NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Level level = ((BlockEntityPeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level2);
        DigitizedItem item = this.checkID(sd, id);
        HashMap root = new HashMap();
        long currentTime = level2.m_46467_();
        Long l = currentTime;
        ((Map)root).put("currentTime", l);
        ((Map)root).put("digitizedAt", item.getDigitizedAt());
        ((Map)root).put("decaysAt", item.getDecaysAt());
        ((Map)root).put("lastRefresh", item.getLastRefresh());
        ((Map)root).put("item", LuaRepresentation.forItemStack$default((LuaRepresentation)LuaRepresentation.INSTANCE, (ItemStack)item.getItem(), null, (int)2, null));
        return root;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsite/siredvin/digitalitems/computercraft/DigitizerPeripheral$Companion;", "", "()V", "TYPE", "", "rand", "Ljava/security/SecureRandom;", "getRand", "()Ljava/security/SecureRandom;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecureRandom getRand() {
            return rand;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

