/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.digitalitems.common.configuration.ModConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010\u00a8\u0006("}, d2={"Lsite/siredvin/digitalitems/common/DigitizedItem;", "", "id", "", "item", "Lnet/minecraft/world/item/ItemStack;", "currentTime", "", "([BLnet/minecraft/world/item/ItemStack;J)V", "compoundTag", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)V", "decaysAt", "getDecaysAt", "()J", "setDecaysAt", "(J)V", "digitizedAt", "getDigitizedAt", "setDigitizedAt", "Ljava/nio/ByteBuffer;", "getId", "()Ljava/nio/ByteBuffer;", "setId", "(Ljava/nio/ByteBuffer;)V", "getItem", "()Lnet/minecraft/world/item/ItemStack;", "setItem", "(Lnet/minecraft/world/item/ItemStack;)V", "lastRefresh", "getLastRefresh", "setLastRefresh", "decayed", "", "level", "Lnet/minecraft/world/level/Level;", "refresh", "", "serialize", "Companion", "digitalitems-forge-1.20.1"})
public final class DigitizedItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ByteBuffer id;
    @NotNull
    private ItemStack item;
    private long digitizedAt;
    private long lastRefresh;
    private long decaysAt;

    @NotNull
    public final ByteBuffer getId() {
        return this.id;
    }

    public final void setId(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<set-?>");
        this.id = byteBuffer;
    }

    @NotNull
    public final ItemStack getItem() {
        return this.item;
    }

    public final void setItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.item = itemStack;
    }

    public final long getDigitizedAt() {
        return this.digitizedAt;
    }

    public final void setDigitizedAt(long l) {
        this.digitizedAt = l;
    }

    public final long getLastRefresh() {
        return this.lastRefresh;
    }

    public final void setLastRefresh(long l) {
        this.lastRefresh = l;
    }

    public final long getDecaysAt() {
        return this.decaysAt;
    }

    public final void setDecaysAt(long l) {
        this.decaysAt = l;
    }

    public DigitizedItem(@NotNull byte[] id, @NotNull ItemStack item, long currentTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ByteBuffer byteBuffer = ByteBuffer.wrap(id);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(id)");
        this.id = byteBuffer;
        this.item = item;
        this.digitizedAt = currentTime;
        this.lastRefresh = currentTime;
        this.decaysAt = currentTime + ModConfig.INSTANCE.getDecayTicks();
    }

    public DigitizedItem(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        ByteBuffer byteBuffer = ByteBuffer.wrap(compoundTag.m_128463_("id"));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(compoundTag.getByteArray(\"id\"))");
        this.id = byteBuffer;
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("itemStack"));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"of(compoundTag.getCompound(\"itemStack\"))");
        this.item = itemStack;
        this.digitizedAt = compoundTag.m_128454_("digitizedAt");
        this.lastRefresh = compoundTag.m_128454_("lastRefresh");
        this.decaysAt = compoundTag.m_128454_("decaysAt");
    }

    public final void serialize(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        compoundTag.m_128382_("id", DigitizedItem.Companion.getBytes(this.id));
        compoundTag.m_128365_("itemStack", (Tag)this.item.m_41739_(new CompoundTag()));
        compoundTag.m_128356_("digitizedAt", this.digitizedAt);
        compoundTag.m_128356_("lastRefresh", this.lastRefresh);
        compoundTag.m_128356_("decaysAt", this.decaysAt);
    }

    public final boolean decayed(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!ModConfig.INSTANCE.getEnableDecay()) {
            return false;
        }
        MinecraftServer minecraftServer = level.m_7654_();
        Intrinsics.checkNotNull((Object)minecraftServer);
        return this.decaysAt <= minecraftServer.m_129783_().m_46467_();
    }

    public final void refresh(long currentTime) {
        this.lastRefresh = currentTime;
        this.decaysAt = currentTime + ModConfig.INSTANCE.getDecayTicks();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/digitalitems/common/DigitizedItem$Companion;", "", "()V", "getBytes", "", "buf", "Ljava/nio/ByteBuffer;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] getBytes(ByteBuffer buf) {
            if (buf.hasArray()) {
                byte[] byArray = buf.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buf.array()");
                return byArray;
            }
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            return bytes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

