/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.digitalitems.common.DigitizedItem;
import site.siredvin.digitalitems.common.configuration.ModConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/digitalitems/common/DigitalItemsSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "()V", "digitizedItems", "Ljava/util/HashMap;", "Ljava/nio/ByteBuffer;", "Lsite/siredvin/digitalitems/common/DigitizedItem;", "add", "", "item", "get", "id", "pop", "prune", "l", "Lnet/minecraft/world/level/Level;", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Companion", "digitalitems-forge-1.20.1"})
public final class DigitalItemsSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HashMap<ByteBuffer, DigitizedItem> digitizedItems = new HashMap();
    @Nullable
    private static DigitalItemsSavedData instance;

    public final void prune(@NotNull Level l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (!ModConfig.INSTANCE.getEnableDecay()) {
            return;
        }
        long currentTime = l.m_46467_();
        Iterator<Map.Entry<ByteBuffer, DigitizedItem>> it = this.digitizedItems.entrySet().iterator();
        it.forEachRemaining(arg_0 -> DigitalItemsSavedData.prune$lambda$0((Function1)new Function1<Map.Entry<? extends ByteBuffer, ? extends DigitizedItem>, Unit>(currentTime, it){
            final /* synthetic */ long $currentTime;
            final /* synthetic */ Iterator<Map.Entry<ByteBuffer, DigitizedItem>> $it;
            {
                this.$currentTime = $currentTime;
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull Map.Entry<? extends ByteBuffer, DigitizedItem> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                DigitizedItem value = entry.getValue();
                if (this.$currentTime >= value.getDecaysAt()) {
                    this.$it.remove();
                }
            }
        }, arg_0));
        this.m_77762_();
    }

    public final void add(@NotNull DigitizedItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ((Map)this.digitizedItems).put(item.getId(), item);
        this.m_77762_();
    }

    @Nullable
    public final DigitizedItem get(@NotNull ByteBuffer id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.digitizedItems.get(id);
    }

    @Nullable
    public final DigitizedItem pop(@NotNull ByteBuffer id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedItem result = this.digitizedItems.remove(id);
        if (result != null) {
            this.m_77762_();
        }
        return result;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ListTag items = new ListTag();
        this.digitizedItems.values().forEach(arg_0 -> DigitalItemsSavedData.save$lambda$1(items, arg_0));
        tag.m_128365_("items", (Tag)items);
        return tag;
    }

    private static final void prune$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void save$lambda$1(ListTag $items, DigitizedItem digitizedItem) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)digitizedItem, (String)"digitizedItem");
        CompoundTag digitizedItemTag = new CompoundTag();
        digitizedItem.serialize(digitizedItemTag);
        $items.add((Object)digitizedItemTag);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lsite/siredvin/digitalitems/common/DigitalItemsSavedData$Companion;", "", "()V", "instance", "Lsite/siredvin/digitalitems/common/DigitalItemsSavedData;", "create", "getFrom", "l", "Lnet/minecraft/world/level/Level;", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "digitalitems-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DigitalItemsSavedData getFrom(@NotNull Level l) {
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            if (!(l instanceof ServerLevel)) {
                throw new IllegalCallerException("may only be called server side!");
            }
            if (instance != null) {
                DigitalItemsSavedData digitalItemsSavedData = instance;
                Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData));
                return digitalItemsSavedData;
            }
            instance = (DigitalItemsSavedData)((ServerLevel)l).m_7654_().m_129783_().m_8895_().m_164861_(Companion::getFrom$lambda$0, Companion::getFrom$lambda$1, "digitalitems");
            DigitalItemsSavedData digitalItemsSavedData = instance;
            Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData));
            digitalItemsSavedData.prune(l);
            DigitalItemsSavedData digitalItemsSavedData2 = instance;
            Intrinsics.checkNotNull((Object)((Object)digitalItemsSavedData2));
            return digitalItemsSavedData2;
        }

        @NotNull
        public final DigitalItemsSavedData create() {
            return new DigitalItemsSavedData();
        }

        @NotNull
        public final DigitalItemsSavedData load(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            DigitalItemsSavedData data = this.create();
            if (tag.m_128441_("items") && tag.m_128423_("items") instanceof ListTag) {
                Tag tag2 = Objects.requireNonNull(tag.m_128423_("items"));
                Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.ListTag");
                ListTag list = (ListTag)tag2;
                list.forEach(arg_0 -> Companion.load$lambda$2(data, arg_0));
            }
            return data;
        }

        private static final DigitalItemsSavedData getFrom$lambda$0(CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return Companion.load(tag);
        }

        private static final DigitalItemsSavedData getFrom$lambda$1() {
            return Companion.create();
        }

        private static final void load$lambda$2(DigitalItemsSavedData $data, Tag tag1) {
            Intrinsics.checkNotNullParameter((Object)((Object)$data), (String)"$data");
            Intrinsics.checkNotNullParameter((Object)tag1, (String)"tag1");
            Tag tag = Objects.requireNonNull(tag1);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            DigitizedItem di = new DigitizedItem((CompoundTag)tag);
            ((Map)$data.digitizedItems).put(di.getId(), di);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

