/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.registry;

import cool.bot.dewdropfarmland.block.CustomFarmland;
import cool.bot.dewdropfarmland.block.CustomStemBlock;
import cool.bot.dewdropfarmland.block.GardenPotBlock;
import cool.bot.dewdropfarmland.block.SprinklerBlock;
import cool.bot.dewdropfarmland.block.TilledSand;
import cool.bot.dewdropfarmland.item.FertilizerItem;
import cool.bot.dewdropfarmland.registry.CreativeTab;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModElements {
    public static final DeferredRegister<Block> VANILLA_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
    public static final DeferredRegister<Block> FARMLAND_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dew_drop_farmland_growth");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dew_drop_farmland_growth");
    public static final RegistryObject<Block> PUMPKIN_STEM = ModElements.registerVanillaBlock("pumpkin_stem", () -> new CustomStemBlock((StemGrownBlock)Blocks.f_50133_, () -> Items.f_42577_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50189_)));
    public static final RegistryObject<Block> MELON_STEM = ModElements.registerVanillaBlock("melon_stem", () -> new CustomStemBlock((StemGrownBlock)Blocks.f_50186_, () -> Items.f_42578_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50190_)));
    public static final RegistryObject<Block> FARMLAND = ModElements.registerVanillaBlock("farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> WEAK_FERTILIZED_FARMLAND = ModElements.registerModBlock("weak_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> STRONG_FERTILIZED_FARMLAND = ModElements.registerModBlock("strong_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> HYPER_FERTILIZED_FARMLAND = ModElements.registerModBlock("hyper_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> HYDRATING_FARMLAND = ModElements.registerModBlock("hydrating_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> DELUXE_HYDRATING_FARMLAND = ModElements.registerModBlock("deluxe_hydrating_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> BOUNTIFUL_FERTILIZED_FARMLAND = ModElements.registerModBlock("bountiful_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> LOW_QUALITY_FERTILIZED_FARMLAND = ModElements.registerModBlock("low_quality_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> HIGH_QUALITY_FERTILIZED_FARMLAND = ModElements.registerModBlock("high_quality_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> PRISTINE_QUALITY_FERTILIZED_FARMLAND = ModElements.registerModBlock("pristine_quality_fertilized_farmland", () -> new CustomFarmland(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_)));
    public static final RegistryObject<Block> TILLED_SAND = ModElements.registerModBlock("tilled_sand", () -> new TilledSand(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
    public static final RegistryObject<Block> HYPER_FERTILIZED_SAND = ModElements.registerModBlock("hyper_fertilized_sand", () -> new TilledSand(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
    public static final RegistryObject<Block> GARDEN_POT = ModElements.registerModBlock("garden_pot", () -> new GardenPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_)));
    public static final RegistryObject<Block> IRON_HANGING_GARDEN_POT = ModElements.registerModBlock("iron_hanging_garden_pot", () -> new GardenPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> ROPE_HANGING_GARDEN_POT = ModElements.registerModBlock("rope_hanging_garden_pot", () -> new GardenPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_)));
    public static final RegistryObject<Block> IRON_SPRINKLER = ModElements.registerModBlock("iron_sprinkler", () -> new SprinklerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> GOLD_SPRINKLER = ModElements.registerModBlock("gold_sprinkler", () -> new SprinklerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> DIAMOND_SPRINKLER = ModElements.registerModBlock("diamond_sprinkler", () -> new SprinklerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> NETHERITE_SPRINKLER = ModElements.registerModBlock("netherite_sprinkler", () -> new SprinklerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<BlockItem> WEAK_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("weak_fertilized_farmland", () -> new BlockItem((Block)WEAK_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> STRONG_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("strong_fertilized_farmland", () -> new BlockItem((Block)STRONG_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> HYPER_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("hyper_fertilized_farmland", () -> new BlockItem((Block)HYPER_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> HYDRATING_FARMLAND_ITEM = ModElements.registerItem("hydrating_farmland", () -> new BlockItem((Block)HYDRATING_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> DELUXE_HYDRATING_FARMLAND_ITEM = ModElements.registerItem("deluxe_hydrating_farmland", () -> new BlockItem((Block)DELUXE_HYDRATING_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> BOUNTIFUL_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("bountiful_fertilized_farmland", () -> new BlockItem((Block)BOUNTIFUL_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> LOW_QUALITY_FERTILIZED_ITEM = ModElements.registerItem("low_quality_fertilized_farmland", () -> new BlockItem((Block)LOW_QUALITY_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> HIGH_QUALITY_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("high_quality_fertilized_farmland", () -> new BlockItem((Block)HIGH_QUALITY_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> PRISTINE_QUALITY_FERTILIZED_FARMLAND_ITEM = ModElements.registerItem("pristine_quality_fertilized_farmland", () -> new BlockItem((Block)PRISTINE_QUALITY_FERTILIZED_FARMLAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> TILLED_SAND_ITEM = ModElements.registerItem("tilled_sand", () -> new BlockItem((Block)TILLED_SAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> HYPER_FERTILIZED_SAND_ITEM = ModElements.registerItem("hyper_fertilized_sand", () -> new BlockItem((Block)HYPER_FERTILIZED_SAND.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> GARDEN_POT_ITEM = ModElements.registerItem("garden_pot", () -> new BlockItem((Block)GARDEN_POT.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> IRON_SPRINKLER_ITEM = ModElements.registerItem("iron_sprinkler", () -> new BlockItem((Block)IRON_SPRINKLER.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> GOLD_SPRINKLER_ITEM = ModElements.registerItem("gold_sprinkler", () -> new BlockItem((Block)GOLD_SPRINKLER.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> DIAMOND_SPRINKLER_ITEM = ModElements.registerItem("diamond_sprinkler", () -> new BlockItem((Block)DIAMOND_SPRINKLER.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> NETHERITE_SPRINKLER_ITEM = ModElements.registerItem("netherite_sprinkler", () -> new BlockItem((Block)NETHERITE_SPRINKLER.get(), new Item.Properties()));
    public static final RegistryObject<Item> WEAK_FERTILIZER = ModElements.registerItem("weak_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> STRONG_FERTILIZER = ModElements.registerItem("strong_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(64)));
    public static final RegistryObject<Item> HYPER_FERTILIZER = ModElements.registerItem("hyper_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(64)));
    public static final RegistryObject<Item> HYDRATING_FERTILIZER = ModElements.registerItem("hydrating_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> DELUXE_HYDRATING_FERTILIZER = ModElements.registerItem("deluxe_hydrating_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> BOUNTIFUL_FERTILIZER = ModElements.registerItem("bountiful_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> LOW_QUALITY_FERTILIZER = ModElements.registerItem("low_quality_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41487_(64)));
    public static final RegistryObject<Item> HIGH_QUALITY_FERTILIZER = ModElements.registerItem("high_quality_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(64)));
    public static final RegistryObject<Item> PRISTINE_QUALITY_FERTILIZER = ModElements.registerItem("pristine_quality_fertilizer", () -> new FertilizerItem(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(64)));

    private static <T extends Block> RegistryObject<T> registerVanillaBlock(String name, Supplier<T> block) {
        return VANILLA_BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> registerModBlock(String name, Supplier<T> block) {
        return FARMLAND_BLOCKS.register(name, block);
    }

    private static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> item) {
        return CreativeTab.addToTab(ITEMS.register(name, item));
    }

    public static void register(IEventBus eventBus) {
        VANILLA_BLOCKS.register(eventBus);
        FARMLAND_BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
    }
}

