/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.block;

import cool.bot.dewdropfarmland.Config;
import cool.bot.dewdropfarmland.utils.CropHandlerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class TilledSand
extends FallingBlock
implements IForgeBlock {
    public static final VoxelShape SHAPE = TilledSand.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TilledSand(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        ItemStack itemStack = context.m_43722_();
        if (!itemStack.canPerformAction(toolAction)) {
            return null;
        }
        if (ToolActions.SHOVEL_FLATTEN == toolAction && Config.shovelReverting) {
            return Blocks.f_49992_.m_49966_();
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        BlockState plant = plantable.getPlant(world, pos.m_121945_(facing));
        return plantType == PlantType.DESERT;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_186460_(pos, (Block)this, 10);
        if (!Config.dailyReset || !((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46223_()) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        if (dayTime >= (long)Config.dailyTimeMin && dayTime < (long)(Config.dailyTimeMin + 10)) {
            BlockState farmland = level.m_8055_(pos);
            BlockPos abovePos = pos.m_7494_();
            BlockState crop = level.m_8055_(abovePos);
            if (!(crop.m_60734_() instanceof AirBlock)) {
                CropHandlerUtils.growCrop(crop, level, abovePos, farmland, random, true);
            }
        }
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!level.m_5776_()) {
            ((ServerLevel)level).m_186460_(pos, (Block)this, 10);
        }
        super.onBlockStateChange(level, pos, oldState, newState);
    }
}

