/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.techdecor.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.techdecor.CyberneticSystemMod;
import net.mcreator.techdecor.procedures.ProCraftLG4FProcedure;
import net.mcreator.techdecor.procedures.ProOpenBaseStationProcedure;
import net.mcreator.techdecor.world.inventory.GUICraftLG4FHelmetMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUICraftLG4FHelmetButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUICraftLG4FHelmetButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUICraftLG4FHelmetButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUICraftLG4FHelmetButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUICraftLG4FHelmetButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUICraftLG4FHelmetButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUICraftLG4FHelmetMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProCraftLG4FProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProOpenBaseStationProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(GUICraftLG4FHelmetButtonMessage.class, GUICraftLG4FHelmetButtonMessage::buffer, GUICraftLG4FHelmetButtonMessage::new, GUICraftLG4FHelmetButtonMessage::handler);
    }
}

