/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.techdecor.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.techdecor.CyberneticSystemMod;
import net.mcreator.techdecor.procedures.ProCraftMGC5OpenProcedure;
import net.mcreator.techdecor.procedures.ProOpenBaseStationProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA1BooProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA1CheProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA1HelmetProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA1LegProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA2BootsProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA2CheProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA2HelProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftMCA2LegProcedure;
import net.mcreator.techdecor.procedures.ProOpenCraftPHProcedure;
import net.mcreator.techdecor.world.inventory.GUIBaseStationWarsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIBaseStationWarsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIBaseStationWarsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIBaseStationWarsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIBaseStationWarsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIBaseStationWarsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIBaseStationWarsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUIBaseStationWarsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProOpenBaseStationProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProOpenCraftMCA1HelmetProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ProOpenCraftMCA1CheProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ProOpenCraftMCA1LegProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ProOpenCraftMCA1BooProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            ProOpenCraftMCA2HelProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            ProOpenCraftMCA2CheProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ProOpenCraftMCA2LegProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            ProOpenCraftMCA2BootsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            ProOpenCraftPHProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            ProCraftMGC5OpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(GUIBaseStationWarsButtonMessage.class, GUIBaseStationWarsButtonMessage::buffer, GUIBaseStationWarsButtonMessage::new, GUIBaseStationWarsButtonMessage::handler);
    }
}

