/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.techdecor.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.techdecor.CyberneticSystemMod;
import net.mcreator.techdecor.procedures.CybernizationTerminalPriNazhatiiKlavishiProcedure;
import net.mcreator.techdecor.procedures.ProActBoosterProcedure;
import net.mcreator.techdecor.procedures.ProActElectroProcedure;
import net.mcreator.techdecor.procedures.ProActEnergyAttackProcedure;
import net.mcreator.techdecor.procedures.ProActHealingProcedure;
import net.mcreator.techdecor.procedures.ProActTeleportProcedure;
import net.mcreator.techdecor.world.inventory.GUIAbilityCyborgMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GUIAbilityCyborgButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GUIAbilityCyborgButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GUIAbilityCyborgButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GUIAbilityCyborgButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GUIAbilityCyborgButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GUIAbilityCyborgButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GUIAbilityCyborgMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CybernizationTerminalPriNazhatiiKlavishiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProActTeleportProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ProActBoosterProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ProActElectroProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ProActHealingProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ProActEnergyAttackProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(GUIAbilityCyborgButtonMessage.class, GUIAbilityCyborgButtonMessage::buffer, GUIAbilityCyborgButtonMessage::new, GUIAbilityCyborgButtonMessage::handler);
    }
}

