/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.techdecor.network;

import java.util.function.Supplier;
import net.mcreator.techdecor.CyberneticSystemMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CyberneticSystemModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CyberneticSystemMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DNA_Point = message.data.DNA_Point;
                    variables.Mining_DNA_Update = message.data.Mining_DNA_Update;
                    variables.Combat_DNA_Update = message.data.Combat_DNA_Update;
                    variables.Live_DNA_Update = message.data.Live_DNA_Update;
                    variables.Dinning = message.data.Dinning;
                    variables.Cd_Glich = message.data.Cd_Glich;
                    variables.level_dostup = message.data.level_dostup;
                    variables.AtomicHeart = message.data.AtomicHeart;
                    variables.BionicEye = message.data.BionicEye;
                    variables.BionicSkelet = message.data.BionicSkelet;
                    variables.BionicMuscle = message.data.BionicMuscle;
                    variables.Nanomachines = message.data.Nanomachines;
                    variables.BuyEnergy = message.data.BuyEnergy;
                    variables.BuyL1 = message.data.BuyL1;
                    variables.Cyber_inf = message.data.Cyber_inf;
                    variables.BUI_FAK = message.data.BUI_FAK;
                    variables.Buy_Scanner = message.data.Buy_Scanner;
                    variables.fragment_lc2 = message.data.fragment_lc2;
                    variables.buy_lc2 = message.data.buy_lc2;
                    variables.buy_refo_plate = message.data.buy_refo_plate;
                    variables.buy_gc1 = message.data.buy_gc1;
                    variables.buy_gc2a = message.data.buy_gc2a;
                    variables.fragment_gc2b = message.data.fragment_gc2b;
                    variables.buy_gc2b = message.data.buy_gc2b;
                    variables.buy_gc3 = message.data.buy_gc3;
                    variables.buyLG3 = message.data.buyLG3;
                    variables.BionicPalm = message.data.BionicPalm;
                    variables.LG4F = message.data.LG4F;
                    variables.GC4F = message.data.GC4F;
                    variables.CD_SM = message.data.CD_SM;
                    variables.LG5M = message.data.LG5M;
                    variables.LD1M = message.data.LD1M;
                    variables.GC1Z = message.data.GC1Z;
                    variables.LG6P = message.data.LG6P;
                    variables.ES6P = message.data.ES6P;
                    variables.ele_ba = message.data.ele_ba;
                    variables.Cybernization = message.data.Cybernization;
                    variables.battery = message.data.battery;
                    variables.battery_cd = message.data.battery_cd;
                    variables.charging_battery = message.data.charging_battery;
                    variables.CyborgUpdate = message.data.CyborgUpdate;
                    variables.teleport = message.data.teleport;
                    variables.BodyBooster = message.data.BodyBooster;
                    variables.ElectricField = message.data.ElectricField;
                    variables.cd_ability = message.data.cd_ability;
                    variables.quest_cyborg = message.data.quest_cyborg;
                    variables.Chip_blue = message.data.Chip_blue;
                    variables.Chip_red = message.data.Chip_red;
                    variables.Chip_yellow = message.data.Chip_yellow;
                    variables.Chip_green = message.data.Chip_green;
                    variables.Healing = message.data.Healing;
                    variables.EnergyAttack = message.data.EnergyAttack;
                    variables.MB1 = message.data.MB1;
                    variables.MB2 = message.data.MB2;
                    variables.tm1 = message.data.tm1;
                    variables.DG2 = message.data.DG2;
                    variables.special_chip = message.data.special_chip;
                    variables.EnergyShield = message.data.EnergyShield;
                    variables.fuid = message.data.fuid;
                    variables.SociaStatus = message.data.SociaStatus;
                    variables.RER = message.data.RER;
                    variables.LG7R = message.data.LG7R;
                    variables.JP2 = message.data.JP2;
                    variables.regens = message.data.regens;
                    variables.BionicMuscleMiners = message.data.BionicMuscleMiners;
                    variables.NanoLuck = message.data.NanoLuck;
                    variables.ImporHeart = message.data.ImporHeart;
                    variables.GCED = message.data.GCED;
                    variables.SpaMani = message.data.SpaMani;
                    variables.DNA_new_Green_1 = message.data.DNA_new_Green_1;
                    variables.DNA_new_Green_2 = message.data.DNA_new_Green_2;
                    variables.DNA_new_Yellow_1 = message.data.DNA_new_Yellow_1;
                    variables.DNA_new_Yellow_2 = message.data.DNA_new_Yellow_2;
                    variables.DNA_new_Red = message.data.DNA_new_Red;
                    variables.gc2c = message.data.gc2c;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double DNA_Point = 0.0;
        public double Mining_DNA_Update = 0.0;
        public double Combat_DNA_Update = 0.0;
        public double Live_DNA_Update = 0.0;
        public boolean Dinning = false;
        public double Cd_Glich = 0.0;
        public double level_dostup = 0.0;
        public boolean AtomicHeart = false;
        public boolean BionicEye = false;
        public boolean BionicSkelet = false;
        public boolean BionicMuscle = false;
        public boolean Nanomachines = false;
        public boolean BuyEnergy = false;
        public boolean BuyL1 = false;
        public boolean Cyber_inf = false;
        public boolean BUI_FAK = false;
        public boolean Buy_Scanner = false;
        public double fragment_lc2 = 0.0;
        public boolean buy_lc2 = false;
        public boolean buy_refo_plate = false;
        public boolean buy_gc1 = false;
        public boolean buy_gc2a = false;
        public double fragment_gc2b = 0.0;
        public boolean buy_gc2b = false;
        public boolean buy_gc3 = false;
        public boolean buyLG3 = false;
        public boolean BionicPalm = false;
        public boolean LG4F = false;
        public boolean GC4F = false;
        public double CD_SM = 12000.0;
        public boolean LG5M = false;
        public boolean LD1M = false;
        public boolean GC1Z = false;
        public boolean LG6P = false;
        public boolean ES6P = false;
        public boolean ele_ba = false;
        public boolean Cybernization = false;
        public double battery = 0.0;
        public double battery_cd = 0.0;
        public double charging_battery = 0.0;
        public double CyborgUpdate = 0.0;
        public boolean teleport = false;
        public boolean BodyBooster = false;
        public boolean ElectricField = false;
        public double cd_ability = 0.0;
        public double quest_cyborg = 0.0;
        public double Chip_blue = 0.0;
        public double Chip_red = 0.0;
        public double Chip_yellow = 0.0;
        public double Chip_green = 0.0;
        public boolean Healing = false;
        public boolean EnergyAttack = false;
        public boolean MB1 = false;
        public boolean MB2 = false;
        public boolean tm1 = false;
        public boolean DG2 = false;
        public double special_chip = 0.0;
        public boolean EnergyShield = false;
        public double fuid = 0.0;
        public double SociaStatus = 0.0;
        public boolean RER = false;
        public boolean LG7R = false;
        public boolean JP2 = false;
        public double regens = 0.0;
        public boolean BionicMuscleMiners = false;
        public boolean NanoLuck = false;
        public boolean ImporHeart = false;
        public boolean GCED = false;
        public double SpaMani = 0.0;
        public double DNA_new_Green_1 = 0.0;
        public double DNA_new_Green_2 = 0.0;
        public double DNA_new_Yellow_1 = 0.0;
        public double DNA_new_Yellow_2 = 0.0;
        public double DNA_new_Red = 0.0;
        public boolean gc2c = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CyberneticSystemMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("DNA_Point", this.DNA_Point);
            nbt.m_128347_("Mining_DNA_Update", this.Mining_DNA_Update);
            nbt.m_128347_("Combat_DNA_Update", this.Combat_DNA_Update);
            nbt.m_128347_("Live_DNA_Update", this.Live_DNA_Update);
            nbt.m_128379_("Dinning", this.Dinning);
            nbt.m_128347_("Cd_Glich", this.Cd_Glich);
            nbt.m_128347_("level_dostup", this.level_dostup);
            nbt.m_128379_("AtomicHeart", this.AtomicHeart);
            nbt.m_128379_("BionicEye", this.BionicEye);
            nbt.m_128379_("BionicSkelet", this.BionicSkelet);
            nbt.m_128379_("BionicMuscle", this.BionicMuscle);
            nbt.m_128379_("Nanomachines", this.Nanomachines);
            nbt.m_128379_("BuyEnergy", this.BuyEnergy);
            nbt.m_128379_("BuyL1", this.BuyL1);
            nbt.m_128379_("Cyber_inf", this.Cyber_inf);
            nbt.m_128379_("BUI_FAK", this.BUI_FAK);
            nbt.m_128379_("Buy_Scanner", this.Buy_Scanner);
            nbt.m_128347_("fragment_lc2", this.fragment_lc2);
            nbt.m_128379_("buy_lc2", this.buy_lc2);
            nbt.m_128379_("buy_refo_plate", this.buy_refo_plate);
            nbt.m_128379_("buy_gc1", this.buy_gc1);
            nbt.m_128379_("buy_gc2a", this.buy_gc2a);
            nbt.m_128347_("fragment_gc2b", this.fragment_gc2b);
            nbt.m_128379_("buy_gc2b", this.buy_gc2b);
            nbt.m_128379_("buy_gc3", this.buy_gc3);
            nbt.m_128379_("buyLG3", this.buyLG3);
            nbt.m_128379_("BionicPalm", this.BionicPalm);
            nbt.m_128379_("LG4F", this.LG4F);
            nbt.m_128379_("GC4F", this.GC4F);
            nbt.m_128347_("CD_SM", this.CD_SM);
            nbt.m_128379_("LG5M", this.LG5M);
            nbt.m_128379_("LD1M", this.LD1M);
            nbt.m_128379_("GC1Z", this.GC1Z);
            nbt.m_128379_("LG6P", this.LG6P);
            nbt.m_128379_("ES6P", this.ES6P);
            nbt.m_128379_("ele_ba", this.ele_ba);
            nbt.m_128379_("Cybernization", this.Cybernization);
            nbt.m_128347_("battery", this.battery);
            nbt.m_128347_("battery_cd", this.battery_cd);
            nbt.m_128347_("charging_battery", this.charging_battery);
            nbt.m_128347_("CyborgUpdate", this.CyborgUpdate);
            nbt.m_128379_("teleport", this.teleport);
            nbt.m_128379_("BodyBooster", this.BodyBooster);
            nbt.m_128379_("ElectricField", this.ElectricField);
            nbt.m_128347_("cd_ability", this.cd_ability);
            nbt.m_128347_("quest_cyborg", this.quest_cyborg);
            nbt.m_128347_("Chip_blue", this.Chip_blue);
            nbt.m_128347_("Chip_red", this.Chip_red);
            nbt.m_128347_("Chip_yellow", this.Chip_yellow);
            nbt.m_128347_("Chip_green", this.Chip_green);
            nbt.m_128379_("Healing", this.Healing);
            nbt.m_128379_("EnergyAttack", this.EnergyAttack);
            nbt.m_128379_("MB1", this.MB1);
            nbt.m_128379_("MB2", this.MB2);
            nbt.m_128379_("tm1", this.tm1);
            nbt.m_128379_("DG2", this.DG2);
            nbt.m_128347_("special_chip", this.special_chip);
            nbt.m_128379_("EnergyShield", this.EnergyShield);
            nbt.m_128347_("fuid", this.fuid);
            nbt.m_128347_("SociaStatus", this.SociaStatus);
            nbt.m_128379_("RER", this.RER);
            nbt.m_128379_("LG7R", this.LG7R);
            nbt.m_128379_("JP2", this.JP2);
            nbt.m_128347_("regens", this.regens);
            nbt.m_128379_("BionicMuscleMiners", this.BionicMuscleMiners);
            nbt.m_128379_("NanoLuck", this.NanoLuck);
            nbt.m_128379_("ImporHeart", this.ImporHeart);
            nbt.m_128379_("GCED", this.GCED);
            nbt.m_128347_("SpaMani", this.SpaMani);
            nbt.m_128347_("DNA_new_Green_1", this.DNA_new_Green_1);
            nbt.m_128347_("DNA_new_Green_2", this.DNA_new_Green_2);
            nbt.m_128347_("DNA_new_Yellow_1", this.DNA_new_Yellow_1);
            nbt.m_128347_("DNA_new_Yellow_2", this.DNA_new_Yellow_2);
            nbt.m_128347_("DNA_new_Red", this.DNA_new_Red);
            nbt.m_128379_("gc2c", this.gc2c);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.DNA_Point = nbt.m_128459_("DNA_Point");
            this.Mining_DNA_Update = nbt.m_128459_("Mining_DNA_Update");
            this.Combat_DNA_Update = nbt.m_128459_("Combat_DNA_Update");
            this.Live_DNA_Update = nbt.m_128459_("Live_DNA_Update");
            this.Dinning = nbt.m_128471_("Dinning");
            this.Cd_Glich = nbt.m_128459_("Cd_Glich");
            this.level_dostup = nbt.m_128459_("level_dostup");
            this.AtomicHeart = nbt.m_128471_("AtomicHeart");
            this.BionicEye = nbt.m_128471_("BionicEye");
            this.BionicSkelet = nbt.m_128471_("BionicSkelet");
            this.BionicMuscle = nbt.m_128471_("BionicMuscle");
            this.Nanomachines = nbt.m_128471_("Nanomachines");
            this.BuyEnergy = nbt.m_128471_("BuyEnergy");
            this.BuyL1 = nbt.m_128471_("BuyL1");
            this.Cyber_inf = nbt.m_128471_("Cyber_inf");
            this.BUI_FAK = nbt.m_128471_("BUI_FAK");
            this.Buy_Scanner = nbt.m_128471_("Buy_Scanner");
            this.fragment_lc2 = nbt.m_128459_("fragment_lc2");
            this.buy_lc2 = nbt.m_128471_("buy_lc2");
            this.buy_refo_plate = nbt.m_128471_("buy_refo_plate");
            this.buy_gc1 = nbt.m_128471_("buy_gc1");
            this.buy_gc2a = nbt.m_128471_("buy_gc2a");
            this.fragment_gc2b = nbt.m_128459_("fragment_gc2b");
            this.buy_gc2b = nbt.m_128471_("buy_gc2b");
            this.buy_gc3 = nbt.m_128471_("buy_gc3");
            this.buyLG3 = nbt.m_128471_("buyLG3");
            this.BionicPalm = nbt.m_128471_("BionicPalm");
            this.LG4F = nbt.m_128471_("LG4F");
            this.GC4F = nbt.m_128471_("GC4F");
            this.CD_SM = nbt.m_128459_("CD_SM");
            this.LG5M = nbt.m_128471_("LG5M");
            this.LD1M = nbt.m_128471_("LD1M");
            this.GC1Z = nbt.m_128471_("GC1Z");
            this.LG6P = nbt.m_128471_("LG6P");
            this.ES6P = nbt.m_128471_("ES6P");
            this.ele_ba = nbt.m_128471_("ele_ba");
            this.Cybernization = nbt.m_128471_("Cybernization");
            this.battery = nbt.m_128459_("battery");
            this.battery_cd = nbt.m_128459_("battery_cd");
            this.charging_battery = nbt.m_128459_("charging_battery");
            this.CyborgUpdate = nbt.m_128459_("CyborgUpdate");
            this.teleport = nbt.m_128471_("teleport");
            this.BodyBooster = nbt.m_128471_("BodyBooster");
            this.ElectricField = nbt.m_128471_("ElectricField");
            this.cd_ability = nbt.m_128459_("cd_ability");
            this.quest_cyborg = nbt.m_128459_("quest_cyborg");
            this.Chip_blue = nbt.m_128459_("Chip_blue");
            this.Chip_red = nbt.m_128459_("Chip_red");
            this.Chip_yellow = nbt.m_128459_("Chip_yellow");
            this.Chip_green = nbt.m_128459_("Chip_green");
            this.Healing = nbt.m_128471_("Healing");
            this.EnergyAttack = nbt.m_128471_("EnergyAttack");
            this.MB1 = nbt.m_128471_("MB1");
            this.MB2 = nbt.m_128471_("MB2");
            this.tm1 = nbt.m_128471_("tm1");
            this.DG2 = nbt.m_128471_("DG2");
            this.special_chip = nbt.m_128459_("special_chip");
            this.EnergyShield = nbt.m_128471_("EnergyShield");
            this.fuid = nbt.m_128459_("fuid");
            this.SociaStatus = nbt.m_128459_("SociaStatus");
            this.RER = nbt.m_128471_("RER");
            this.LG7R = nbt.m_128471_("LG7R");
            this.JP2 = nbt.m_128471_("JP2");
            this.regens = nbt.m_128459_("regens");
            this.BionicMuscleMiners = nbt.m_128471_("BionicMuscleMiners");
            this.NanoLuck = nbt.m_128471_("NanoLuck");
            this.ImporHeart = nbt.m_128471_("ImporHeart");
            this.GCED = nbt.m_128471_("GCED");
            this.SpaMani = nbt.m_128459_("SpaMani");
            this.DNA_new_Green_1 = nbt.m_128459_("DNA_new_Green_1");
            this.DNA_new_Green_2 = nbt.m_128459_("DNA_new_Green_2");
            this.DNA_new_Yellow_1 = nbt.m_128459_("DNA_new_Yellow_1");
            this.DNA_new_Yellow_2 = nbt.m_128459_("DNA_new_Yellow_2");
            this.DNA_new_Red = nbt.m_128459_("DNA_new_Red");
            this.gc2c = nbt.m_128471_("gc2c");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cybernetic_system", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.DNA_Point = original.DNA_Point;
            clone.Mining_DNA_Update = original.Mining_DNA_Update;
            clone.Combat_DNA_Update = original.Combat_DNA_Update;
            clone.Live_DNA_Update = original.Live_DNA_Update;
            clone.Dinning = original.Dinning;
            clone.Cd_Glich = original.Cd_Glich;
            clone.level_dostup = original.level_dostup;
            clone.AtomicHeart = original.AtomicHeart;
            clone.BionicEye = original.BionicEye;
            clone.BionicSkelet = original.BionicSkelet;
            clone.BionicMuscle = original.BionicMuscle;
            clone.Nanomachines = original.Nanomachines;
            clone.BuyEnergy = original.BuyEnergy;
            clone.BuyL1 = original.BuyL1;
            clone.Cyber_inf = original.Cyber_inf;
            clone.BUI_FAK = original.BUI_FAK;
            clone.Buy_Scanner = original.Buy_Scanner;
            clone.fragment_lc2 = original.fragment_lc2;
            clone.buy_lc2 = original.buy_lc2;
            clone.buy_refo_plate = original.buy_refo_plate;
            clone.buy_gc1 = original.buy_gc1;
            clone.buy_gc2a = original.buy_gc2a;
            clone.fragment_gc2b = original.fragment_gc2b;
            clone.buy_gc2b = original.buy_gc2b;
            clone.buy_gc3 = original.buy_gc3;
            clone.buyLG3 = original.buyLG3;
            clone.BionicPalm = original.BionicPalm;
            clone.LG4F = original.LG4F;
            clone.GC4F = original.GC4F;
            clone.CD_SM = original.CD_SM;
            clone.LG5M = original.LG5M;
            clone.LD1M = original.LD1M;
            clone.GC1Z = original.GC1Z;
            clone.LG6P = original.LG6P;
            clone.ES6P = original.ES6P;
            clone.ele_ba = original.ele_ba;
            clone.Cybernization = original.Cybernization;
            clone.battery = original.battery;
            clone.battery_cd = original.battery_cd;
            clone.charging_battery = original.charging_battery;
            clone.CyborgUpdate = original.CyborgUpdate;
            clone.teleport = original.teleport;
            clone.BodyBooster = original.BodyBooster;
            clone.ElectricField = original.ElectricField;
            clone.cd_ability = original.cd_ability;
            clone.quest_cyborg = original.quest_cyborg;
            clone.Chip_blue = original.Chip_blue;
            clone.Chip_red = original.Chip_red;
            clone.Chip_yellow = original.Chip_yellow;
            clone.Chip_green = original.Chip_green;
            clone.Healing = original.Healing;
            clone.EnergyAttack = original.EnergyAttack;
            clone.MB1 = original.MB1;
            clone.MB2 = original.MB2;
            clone.tm1 = original.tm1;
            clone.DG2 = original.DG2;
            clone.special_chip = original.special_chip;
            clone.EnergyShield = original.EnergyShield;
            clone.fuid = original.fuid;
            clone.SociaStatus = original.SociaStatus;
            clone.RER = original.RER;
            clone.LG7R = original.LG7R;
            clone.JP2 = original.JP2;
            clone.regens = original.regens;
            clone.BionicMuscleMiners = original.BionicMuscleMiners;
            clone.NanoLuck = original.NanoLuck;
            clone.ImporHeart = original.ImporHeart;
            clone.GCED = original.GCED;
            clone.SpaMani = original.SpaMani;
            clone.DNA_new_Green_1 = original.DNA_new_Green_1;
            clone.DNA_new_Green_2 = original.DNA_new_Green_2;
            clone.DNA_new_Yellow_1 = original.DNA_new_Yellow_1;
            clone.DNA_new_Yellow_2 = original.DNA_new_Yellow_2;
            clone.DNA_new_Red = original.DNA_new_Red;
            clone.gc2c = original.gc2c;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

