/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.mixin.ContraptionAccessor;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private BlockPos pos;
    private int entityId;
    private boolean isOnContraption;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;
    private IDisplaySettings settings;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(Level level, BlockPos pos, AbstractContraptionEntity contraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.isOnContraption = contraption != null;
        this.entityId = this.isOnContraption ? contraption.m_19879_() : 0;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
        if (this.isOnContraption) {
            this.applyContraption(contraption, this);
        } else {
            this.apply(level, this);
        }
    }

    protected AdvancedDisplayUpdatePacket(BlockPos pos, int entityId, boolean isOnContraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.entityId = entityId;
        this.isOnContraption = isOnContraption;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, FriendlyByteBuf buffer) {
        CompoundTag k = new CompoundTag();
        packet.key.toNbt(k);
        buffer.m_130064_(packet.pos);
        buffer.m_130079_(k);
        buffer.writeBoolean(packet.doubleSided);
        buffer.writeBoolean(packet.isOnContraption);
        buffer.writeInt(packet.entityId);
        buffer.m_130079_(packet.settings.serializeNbt());
    }

    public AdvancedDisplayUpdatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.m_130260_());
        boolean doubleSided = buffer.readBoolean();
        boolean isOnContraption = buffer.readBoolean();
        int entityId = buffer.readInt();
        IDisplaySettings settings = AdvancedDisplaysRegistry.createSettings(key);
        settings.deserializeNbt(buffer.m_130260_());
        return new AdvancedDisplayUpdatePacket(pos, entityId, isOnContraption, key, doubleSided, settings);
    }

    private void apply(Level level, AdvancedDisplayUpdatePacket packet) {
        BlockEntity blockEntity;
        if (level.m_46749_(packet.pos) && (blockEntity = level.m_7702_(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity2.applyToAll(be -> {
                be.setDisplayType(level, packet.key, packet.settings);
                if (level.m_8055_(be.m_58899_()).m_60734_() instanceof AbstractAdvancedSidedDisplayBlock) {
                    BlockState state = level.m_8055_(be.m_58899_());
                    state = (BlockState)state.m_61124_(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.m_46597_(be.m_58899_(), state);
                }
                be.notifyUpdate();
            }, new IBlockGetter.WorldBlockGetter(level));
        }
    }

    private void applyContraption(AbstractContraptionEntity contraptionEntity, AdvancedDisplayUpdatePacket packet) {
        Object object;
        Contraption contraption = contraptionEntity.getContraption();
        ContraptionWorld level = contraption.getContraptionWorld();
        HashSet<BlockPos> blockEntityPositions = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos pos = packet.pos.m_122032_();
        MutablePair rootActor = contraption.getActorAt((BlockPos)pos);
        if (rootActor == null || rootActor.right == null) {
            return;
        }
        MovementContext rootCtx = (MovementContext)rootActor.getRight();
        StructureTemplate.StructureBlockInfo rootInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        Direction side = ((Direction)rootCtx.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        int width = rootCtx.blockEntityData.m_128445_("XSize");
        int height = rootCtx.blockEntityData.m_128445_("YSize");
        Map<BlockPos, CompoundTag> updateTags = ((ContraptionAccessor)contraption).crn$updateTags();
        packet.key.toNbt(rootCtx.blockEntityData);
        packet.key.toNbt(rootCtx.data);
        packet.key.toNbt(rootInfo.f_74677_());
        rootCtx.blockEntityData.m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
        rootCtx.data.m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
        rootInfo.f_74677_().m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
        blockEntityPositions.add(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        if (rootInfo.f_74676_().m_60734_() instanceof AbstractAdvancedSidedDisplayBlock) {
            BlockState newState = (BlockState)rootInfo.f_74676_().m_61124_(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
            contraption.getBlocks().put(pos, new StructureTemplate.StructureBlockInfo(rootInfo.f_74675_(), newState, rootInfo.f_74677_()));
            contraption.resetClientContraption();
        }
        if ((object = CRNPlatformSpecific.getClientContraptionBlockEntity(contraption, (BlockPos)pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)object;
            be.setDisplayType((Level)level, packet.key, packet.settings);
            be.m_155250_(((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos)).f_74676_());
        }
        for (int i = 0; i < width && i < 16; ++i) {
            BlockPos newPos = pos.m_5484_(side, i);
            for (int j = 0; j < height && j < 16; ++j) {
                BlockPos newPos2 = newPos.m_5484_(Direction.DOWN, j);
                MutablePair actor = contraption.getActorAt(newPos2);
                if (actor == null || actor.right == null) continue;
                blockEntityPositions.add(new BlockPos(newPos2.m_123341_(), newPos2.m_123342_(), newPos2.m_123343_()));
                MovementContext ctx = (MovementContext)actor.getRight();
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(newPos2);
                packet.key.toNbt(ctx.blockEntityData);
                packet.key.toNbt(ctx.data);
                packet.key.toNbt(info.f_74677_());
                ctx.blockEntityData.m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
                ctx.data.m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
                info.f_74677_().m_128365_("DisplaySettings", (Tag)packet.settings.serializeNbt());
                BlockEntity blockEntity = CRNPlatformSpecific.getClientContraptionBlockEntity(contraption, newPos2);
                if (blockEntity instanceof AdvancedDisplayBlockEntity) {
                    AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
                    be.setDisplayType((Level)level, packet.key, packet.settings);
                    be.m_155250_(((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(newPos2)).f_74676_());
                }
                if (!(info.f_74676_().m_60734_() instanceof AbstractAdvancedSidedDisplayBlock)) continue;
                BlockState newState = (BlockState)info.f_74676_().m_61124_(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                contraption.getBlocks().put(newPos2, new StructureTemplate.StructureBlockInfo(newPos2, newState, info.f_74677_()));
            }
        }
        IBlockGetter.ContraptionBlockGetter getter = new IBlockGetter.ContraptionBlockGetter(contraptionEntity);
        for (MutablePair a : contraption.getActors()) {
            BlockEntity blockEntity = getter.getBlockEntity(((StructureTemplate.StructureBlockInfo)a.getLeft()).f_74675_());
            if (!(blockEntity instanceof AdvancedDisplayBlockEntity)) continue;
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
            be.updateControllerStatus2(getter);
            if (level.m_5776_()) {
                be.getRenderer().update((Level)level, ((StructureTemplate.StructureBlockInfo)a.getLeft()).f_74675_(), be.m_58900_(), (BlockEntity)be, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            if (!updateTags.containsKey(((StructureTemplate.StructureBlockInfo)a.getLeft()).f_74675_())) continue;
            be.writeClient(updateTags.get(((StructureTemplate.StructureBlockInfo)a.getLeft()).f_74675_()));
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                Level level = player.m_9236_();
                if (packet.isOnContraption) {
                    Entity patt0$temp = level.m_6815_(packet.entityId);
                    if (patt0$temp instanceof AbstractContraptionEntity) {
                        AbstractContraptionEntity ce = (AbstractContraptionEntity)patt0$temp;
                        this.applyContraption(ce, packet);
                    }
                } else {
                    this.apply(level, packet);
                }
            }
        });
    }
}

