/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.instruction;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.schedule.instruction.IPredictableInstruction;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.ModBlocks;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TravelSectionInstruction
extends ScheduleInstruction
implements IPredictableInstruction {
    @Deprecated
    public static final String LEGACY_NBT_TRAIN_CATEGORY = "TrainGroup";
    public static final String NBT_TRAIN_CATEGORY = "TrainCategory";
    public static final String NBT_TRAIN_LINE = "TrainLine";
    public static final String NBT_INCLUDE_PREVIOUS_STATION = "IncludePreviousStation";
    public static final String NBT_USABLE = "Usable";
    private final MutableComponent txtNone = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.none").m_130940_(ChatFormatting.GRAY);
    private final MutableComponent txtLoading = TextUtils.empty().m_7220_(Constants.TEXT_LOADING).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
    private UUID lastCategoryId = null;
    private UUID lastLineId = null;
    private TrainCategory category;
    private TrainLine line;

    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (!tag.m_128441_(NBT_INCLUDE_PREVIOUS_STATION)) {
            tag.m_128379_(NBT_INCLUDE_PREVIOUS_STATION, false);
        }
        if (!tag.m_128441_(NBT_USABLE)) {
            tag.m_128379_(NBT_USABLE, true);
        }
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)ModBlocks.ADVANCED_DISPLAY.get()), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().m_135815_())).m_130940_(ChatFormatting.AQUA));
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "travel_section");
    }

    public boolean supportsConditions() {
        return false;
    }

    public DiscoveredPath start(ScheduleRuntime runtime, Level level) {
        TrainListener.getTrainData(runtime.train.id).ifPresent(x -> {
            x.addScheduleSection(this.getSectionData((TrainData)x, runtime.currentEntry));
            x.changeCurrentSection(runtime.currentEntry);
        });
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
        return null;
    }

    private void requestCategory(UUID categoryId) {
        this.lastCategoryId = null;
        this.category = null;
        if (categoryId == null) {
            return;
        }
        DataAccessor.getFromServer((Object)categoryId, ModAccessorTypes.GET_TRAIN_CATEGORY, category -> {
            this.lastCategoryId = categoryId;
            this.category = category.orElse(null);
        });
    }

    private void requestLine(UUID lineId) {
        this.lastLineId = null;
        this.line = null;
        if (lineId == null) {
            return;
        }
        DataAccessor.getFromServer((Object)lineId, ModAccessorTypes.GET_TRAIN_LINE, line -> {
            this.lastLineId = lineId;
            this.line = line.orElse(null);
        });
    }

    public List<Component> getTitleAs(String type) {
        UUID categoryId = null;
        UUID lineId = null;
        if (this.data.m_128441_(LEGACY_NBT_TRAIN_CATEGORY)) {
            categoryId = this.data.m_128435_(LEGACY_NBT_TRAIN_CATEGORY) == 8 ? TrainCategory.genMD5Uuid(this.data.m_128461_(LEGACY_NBT_TRAIN_CATEGORY)) : this.data.m_128342_(LEGACY_NBT_TRAIN_CATEGORY);
        } else if (this.data.m_128441_(NBT_TRAIN_CATEGORY)) {
            categoryId = this.data.m_128342_(NBT_TRAIN_CATEGORY);
        }
        if (this.data.m_128441_(NBT_TRAIN_LINE)) {
            lineId = this.data.m_128435_(NBT_TRAIN_LINE) == 8 ? TrainLine.genMD5Uuid(this.data.m_128461_(NBT_TRAIN_LINE)) : this.data.m_128342_(NBT_TRAIN_LINE);
        }
        if (this.lastCategoryId == null || categoryId == null || !this.lastCategoryId.equals(categoryId)) {
            this.requestCategory(categoryId);
        }
        if (this.lastLineId == null || lineId == null || !this.lastLineId.equals(lineId)) {
            this.requestLine(lineId);
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_())).m_130940_(ChatFormatting.GOLD));
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".description")).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".train_category")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)(this.lastCategoryId == null && this.category != null ? this.txtLoading : (this.category == null ? this.txtNone : TextUtils.text((String)this.category.getCategoryName()).m_130940_(ChatFormatting.WHITE)))));
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".train_line")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)(this.lastLineId == null && this.line != null ? this.txtLoading : (this.line == null ? this.txtNone : TextUtils.text((String)this.line.getLineName()).m_130940_(ChatFormatting.WHITE)))));
        if (this.data.m_128441_(NBT_INCLUDE_PREVIOUS_STATION)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".include_previous_station")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_(this.data.m_128471_(NBT_INCLUDE_PREVIOUS_STATION) ? CommonComponents.f_130657_ : CommonComponents.f_130658_));
        }
        if (this.data.m_128441_(NBT_USABLE)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".usable")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_(this.data.m_128471_(NBT_USABLE) ? CommonComponents.f_130657_ : CommonComponents.f_130658_));
        }
        return lines;
    }

    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initScheduleSectionInstruction(this, builder);
    }

    private ScheduleSection getSectionData(TrainData data, int index) {
        String categoryNbtKey = null;
        categoryNbtKey = this.data.m_128441_(LEGACY_NBT_TRAIN_CATEGORY) ? LEGACY_NBT_TRAIN_CATEGORY : NBT_TRAIN_CATEGORY;
        return new ScheduleSection(data, index, !this.data.m_128441_(categoryNbtKey) || this.data.m_128435_(categoryNbtKey) != 8 && this.data.m_128435_(categoryNbtKey) != 11 ? null : (TrainCategory)GlobalSettings.getInstance().getTrainCategory(this.data.m_128435_(categoryNbtKey) == 8 ? TrainCategory.genMD5Uuid(this.data.m_128461_(categoryNbtKey)) : this.data.m_128342_(categoryNbtKey)).orElse(null), !this.data.m_128441_(NBT_TRAIN_LINE) || this.data.m_128435_(NBT_TRAIN_LINE) != 8 && this.data.m_128435_(NBT_TRAIN_LINE) != 11 ? null : (TrainLine)GlobalSettings.getInstance().getTrainLine(this.data.m_128435_(NBT_TRAIN_LINE) == 8 ? TrainCategory.genMD5Uuid(this.data.m_128461_(NBT_TRAIN_LINE)) : this.data.m_128342_(NBT_TRAIN_LINE)).orElse(null), this.data.m_128471_(NBT_INCLUDE_PREVIOUS_STATION), this.data.m_128471_(NBT_USABLE));
    }

    @Override
    public void predict(TrainData data, ScheduleRuntime runtime, int indexInSchedule, Train train) {
        DLUtils.doIfNotNull((Object)data, x -> x.addScheduleSection(this.getSectionData((TrainData)x, indexInSchedule)));
    }
}

