/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import de.mrjulsen.crn.data.navigation.Node;
import de.mrjulsen.crn.data.train.TrainPrediction;
import java.util.UUID;

public class EdgeData
implements Comparable<EdgeData> {
    private final TrainPrediction prediction;
    private final Node node1;
    private final Node node2;
    private long cost = -1L;

    protected EdgeData(Node node1, Node node2, TrainPrediction prediction, long cost) {
        this.prediction = prediction;
        this.node1 = node1;
        this.node2 = node2;
        this.cost = cost;
    }

    public EdgeData(Node node1, Node node2, TrainPrediction prediction) {
        this(node1, node2, prediction, prediction.transitTime().value());
    }

    public Node getFirstNode() {
        return this.node1;
    }

    public Node getSecondNode() {
        return this.node2;
    }

    public UUID getTrainId() {
        return this.prediction.getData().getTrainId();
    }

    public boolean connected(EdgeData other) {
        return this.getTrainId().equals(other.getTrainId()) && this.getSectionIndex() == other.getSectionIndex();
    }

    public int getSectionIndex() {
        return this.prediction.getSection().getScheduleIndex();
    }

    public TrainPrediction getPrediction() {
        return this.prediction;
    }

    public long getCost() {
        return this.cost;
    }

    public EdgeData invert() {
        return new EdgeData(this.node2, this.node1, this.prediction);
    }

    @Override
    public int compareTo(EdgeData o) {
        return Long.compare(this.cost, o.cost);
    }
}

