/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import de.mrjulsen.crn.client.gui.widgets.ModCommandSuggestions;
import de.mrjulsen.crn.data.StationTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class ModDestinationSuggestions
extends ModCommandSuggestions {
    private List<StationTag> viableStations;
    private String previous = "<>";
    private Font font;
    private boolean active;
    private List<Suggestion> currentSuggestions;
    private int yOffset;

    public ModDestinationSuggestions(Minecraft pMinecraft, Screen pScreen, EditBox pInput, Font pFont, List<StationTag> viableStations, int yOffset) {
        super(pMinecraft, pScreen, pInput, pFont, true, true, 0, 7, false, -298831824);
        this.font = pFont;
        this.viableStations = viableStations;
        this.yOffset = yOffset;
        this.currentSuggestions = new ArrayList<Suggestion>();
        this.active = false;
    }

    public void tick() {
        if (this.suggestions == null) {
            this.input.m_94167_("");
        }
        if (this.active == this.input.m_93696_()) {
            return;
        }
        this.active = this.input.m_93696_();
        this.updateCommandInfo();
    }

    @Override
    public void updateCommandInfo() {
        String value = this.input.m_94155_();
        if (value.equals(this.previous)) {
            return;
        }
        if (!this.active) {
            this.suggestions = null;
            return;
        }
        this.previous = value;
        this.currentSuggestions = this.viableStations.stream().filter(ia -> !ia.getTagName().get().equals(value) && ia.getTagName().get().toLowerCase().startsWith(value.toLowerCase())).map(s -> new Suggestion(new StringRange(0, s.getTagName().get().length()), s.getTagName().get())).toList();
        this.showSuggestions(false);
    }

    @Override
    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        if (this.currentSuggestions.isEmpty()) {
            this.suggestions = null;
            return;
        }
        int width = 0;
        for (Suggestion suggestion : this.currentSuggestions) {
            width = Math.max(width, this.font.m_92895_(suggestion.getText()));
        }
        int x = Mth.m_14045_((int)this.input.m_94211_(0), (int)0, (int)(this.input.m_94211_(0) + this.input.m_94210_() - width));
        this.suggestions = new ModCommandSuggestions.SuggestionsList(x, this.yOffset, width, this.currentSuggestions, false);
    }

    public EditBox getEditBox() {
        return this.input;
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }
}

