/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayScrollingTextSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERPlatformSimple
implements AbstractAdvancedDisplayRenderer<PlatformDisplayScrollingTextSettings> {
    private static final String keyTrainDeparture = "gui.createrailwaysnavigator.route_overview.notification.journey_begins";
    private static final String keyTrainDepartureWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.journey_begins_with_platform";
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private final BERLabel label = new BERLabel().setPos(3.0f, 5.5f).setYScale(0.75f).setScale(0.75f, 0.75f).setCentered(true).setScrollingSpeed(2.0f);
    private List<Component> texts;
    boolean updateLabel = false;

    @Override
    public void renderTick(float deltaTime) {
        this.label.renderTick();
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        ArrayList<Component> textContent = new ArrayList<Component>(this.texts);
        if (blockEntity.getXSize() > 2) {
            textContent.add(0, (Component)CustomLanguage.translate(keyTime, TimeUtils.parseTime((long)((int)(blockEntity.m_58904_().m_46468_() % DragonLib.ticksPerDay() + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
        } else {
            textContent.add(0, (Component)TextUtils.text((String)TimeUtils.parseTime((long)((int)(blockEntity.m_58904_().m_46468_() % DragonLib.ticksPerDay() + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
        }
        MutableComponent txt = TextUtils.concat(textContent);
        this.label.setText((Component)txt);
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        this.label.render(graphics, light);
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> x.getStationData().getRealTimeArrivalTime() < DragonLib.getCurrentWorldTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue() && (!x.getTrainData().isCancelled() || DragonLib.getCurrentWorldTime() < x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())).toList();
        this.label.setColor(0xFF000000 | ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL);
        this.texts = new ArrayList<Component>();
        this.texts.addAll(preds.stream().filter(x -> !x.isNextSectionExcluded()).map(x -> {
            String timeString = ModUtils.formatTime(x.getStationData().getScheduledDepartureTime(), ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA);
            MutableComponent text = TextUtils.empty();
            if (x.getStationData().getRealTimeStation().info().platform() == null || x.getStationData().getRealTimeStation().info().platform().isBlank()) {
                text.m_7220_((Component)CustomLanguage.translate(keyTrainDeparture, x.getTrainData().getName(), x.getStationData().getDestination(), timeString));
            } else {
                text.m_7220_((Component)CustomLanguage.translate(keyTrainDepartureWithPlatform, x.getTrainData().getName(), x.getStationData().getDestination(), timeString, x.getStationData().getRealTimeStation().info().platform()));
            }
            if (x.getTrainData().isCancelled()) {
                text.m_130946_(", ").m_130946_(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled2").getString());
            } else if (x.getStationData().isDepartureDelayed()) {
                String delay = ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(x.getStationData().getDepartureTimeDeviation()) : String.valueOf(TimeUtils.formatToMinutes((long)x.getStationData().getDepartureTimeDeviation()));
                String timeUnitSuffix = ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS ? " " + CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix").getString() : "";
                text.m_130946_(", ").m_130946_(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed2", delay, timeUnitSuffix).getString());
                if (x.getTrainData().hasStatusInfo()) {
                    text.m_130946_(" ").m_130946_(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.reason").getString()).m_7220_(x.getTrainData().getStatus().get(0).text());
                }
            }
            return text;
        }).toList());
    }
}

