/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.api.client.Screens;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.NavigatorToast;
import de.mrjulsen.crn.client.gui.screen.AdvancedDisplaySettingsScreen;
import de.mrjulsen.crn.client.gui.screen.PrioritizedDestinationInstructionSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.TrainDebugScreen;
import de.mrjulsen.crn.client.gui.screen.TrainSectionSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.TrainSeparationSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.ResizableButton;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.schedule.condition.TrainSeparationCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.schedule.instruction.ResetTimingsInstruction;
import de.mrjulsen.crn.data.schedule.instruction.TravelSectionInstruction;
import de.mrjulsen.crn.mixin.ModularGuiLineBuilderAccessor;
import de.mrjulsen.crn.mixin.ScheduleScreenAccessor;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.createmod.catnip.data.Pair;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientWrapper {
    public static final ModelResourceLocation NAVIGATOR_WORLD_MODEL = new ModelResourceLocation("createrailwaysnavigator", "navigator_world", "inventory");
    private static CustomLanguage currentLanguage;
    private static Language currentClientLanguage;

    public static void showNavigatorGui() {
        Screens.showNavigatorScreen(null, false);
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void handleErrorMessagePacket(ServerErrorPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, Constants.TEXT_SERVER_ERROR, (Component)TextUtils.text((String)packet.message)));
    }

    public static void showAdvancedDisplaySettingsScreen(AdvancedDisplayBlockEntity blockEntity, AbstractContraptionEntity contraption) {
        DLScreen.setScreen((DLScreen)new AdvancedDisplaySettingsScreen(blockEntity, contraption));
    }

    public static void updateLanguage(CustomLanguage lang, boolean force) {
        LanguageInfo info;
        if (currentLanguage == lang && !force) {
            return;
        }
        LanguageInfo languageInfo = info = lang == CustomLanguage.DEFAULT ? null : Minecraft.m_91087_().m_91102_().m_118976_(lang.getCode());
        if (info == null) {
            info = Minecraft.m_91087_().m_91102_().m_118976_(Minecraft.m_91087_().m_91102_().m_264236_());
        }
        currentLanguage = lang;
        if (lang == CustomLanguage.DEFAULT || info == null) {
            currentClientLanguage = Language.m_128107_();
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: (Default)");
        } else {
            currentClientLanguage = ClientLanguage.m_264420_((ResourceManager)Minecraft.m_91087_().m_91098_(), List.of(lang == CustomLanguage.DEFAULT ? Minecraft.m_91087_().m_91102_().m_264236_() : lang.getCode()), (boolean)false);
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: " + (info == null ? null : info.f_118945_()));
        }
    }

    public static Language getCurrentClientLanguage() {
        return currentClientLanguage == null ? Language.m_128107_() : currentClientLanguage;
    }

    public static void sendCRNNotification(Component title, Component description) {
        if (((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get()).booleanValue()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)NavigatorToast.multiline(title, description));
        }
    }

    public static int renderMultilineLabelSafe(Graphics graphics, int x, int y, Font font, Component text, int maxWidth, int color) {
        MultiLineLabel label = MultiLineLabel.m_94341_((Font)font, (FormattedText)text, (int)maxWidth);
        GuiGraphics guiGraphics = graphics.graphics();
        Objects.requireNonNull(font);
        label.m_6516_(guiGraphics, x, y, 9, color);
        Objects.requireNonNull(font);
        return 9 * label.m_5770_();
    }

    public static int getTextBlockHeight(Font font, Component text, int maxWidth) {
        int lines = font.m_92923_((FormattedText)text, maxWidth).size();
        Objects.requireNonNull(font);
        return lines * 9;
    }

    public static void showTrainDebugScreen() {
        RenderSystem.recordRenderCall(() -> DLScreen.setScreen((DLScreen)new TrainDebugScreen(null)));
    }

    public static void initPrioritizedDestinationInstruction(PrioritizedDestinationInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.m_91087_().m_91152_((Screen)new PrioritizedDestinationInstructionSettingsScreen((Screen)scheduleScreen, instruction, instruction.getData()));
            }
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.m_5953_(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.m_142518_() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.m_252754_() + this.f_93618_ / 2), (int)(this.m_252907_() + (this.f_93619_ - 8) / 2), (FormattedText)this.m_6035_(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initScheduleSectionInstruction(TravelSectionInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.m_91087_().m_91152_((Screen)new TrainSectionSettingsScreen((Screen)scheduleScreen, instruction.getData()));
            }
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.m_5953_(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.m_142518_() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.m_252754_() + this.f_93618_ / 2), (int)(this.m_252907_() + (this.f_93619_ - 8) / 2), (FormattedText)this.m_6035_(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initResetTimingsInstruction(ResetTimingsInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 16, 16, (Component)TextUtils.empty(), b -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Scheduled-Time-and-Real-Time")){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.m_5953_(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                ModGuiIcons.HELP.render(graphics, this.m_252754_(), this.m_252907_());
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"help_btn"));
    }

    public static void initDynamicDelayCondition(DynamicDelayCondition condition, ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 26, (i, l) -> {
            i.titled(TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + condition.getId().m_135815_() + ".min_duration"))).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Min");
        builder.addScrollInput(26, 26, (i, l) -> {
            i.titled(CreateLang.translateDirect((String)"generic.duration", (Object[])new Object[0])).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Value");
        builder.addSelectionScrollInput(52, 58, (i, l) -> i.forOptions(TimedWaitCondition.TimeUnit.translatedOptions()).titled(CreateLang.translateDirect((String)"generic.timeUnit", (Object[])new Object[0])), "TimeUnit");
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX() + 110, accessor.crn$getY() - 4, 16, 16, (Component)TextUtils.empty(), b -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Dynamic-Delays")){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.m_5953_(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                ModGuiIcons.HELP.render(graphics, this.m_252754_(), this.m_252907_());
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"help_btn"));
    }

    public static void initTimingAdjustmentGui(TrainSeparationCondition condition, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                Minecraft.m_91087_().m_91152_((Screen)new TrainSeparationSettingsScreen((Screen)scheduleScreen, condition.getData()));
            }
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)this.m_252754_(), (int)this.m_252907_(), (int)this.f_93618_, (int)this.f_93619_, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)(this.m_142518_() ? (this.m_93696_() || this.m_5953_(mouseX, mouseY) ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED));
                int j = this.m_142518_() ? -1 : -6381922;
                GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.m_91087_().f_91062_, (int)(this.m_252754_() + this.f_93618_ / 2), (int)(this.m_252907_() + (this.f_93619_ - 8) / 2), (FormattedText)this.m_6035_(), (int)j, (EAlignment)EAlignment.CENTER, (boolean)true);
            }
        };
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void renderNavigatorItem(RenderGraphics graphics, ItemStack itemStack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        if (context != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && context != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && context != ItemDisplayContext.FIXED) {
            return;
        }
        int backgroundId = itemStack.m_41784_().m_128451_("BackgroundId");
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252880_(4.0f, 2.0f, -1.26f);
        BERUtils.renderTexture((ResourceLocation)new ResourceLocation("createrailwaysnavigator", String.format("textures/item/navigator_backgrounds/%s.png", backgroundId)), (RenderGraphics)graphics, (boolean)false, (float)0.0f, (float)0.0f, (float)0.0f, (float)8.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.6666667f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)0xF000F0);
        poseStack.m_252880_(0.0f, 0.0f, -0.01f);
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 0.8f, 0.0f);
        poseStack.m_85841_(0.075f, 0.075f, 0.075f);
        BERUtils.drawString((RenderGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.date", (Object[])new Object[]{(DragonLib.getCurrentWorldTime() + DragonLib.daytimeShift()) / DragonLib.ticksPerDay()}), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 2.0f, 0.0f);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        BERUtils.drawString((RenderGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (String)TimeUtils.formatTime((long)DragonLib.getCurrentWorldTime(), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.m_85849_();
    }

    public static Owner getMe() {
        return new Owner((Player)Minecraft.m_91087_().f_91074_);
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

