/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.jm.OreDistanceInfo;
import com.tom.createores.jm.OreNearbyInfo;
import com.tom.createores.jm.OreVeinInfo;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public enum OreVeinsOverlay {
    INSTANCE;

    private static final Gson gson;
    private IClientAPI api;
    private Map<DimChunkPos, OreVeinInfo> chunkDataLegacy = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, OreVeinInfo> chunkDataAtlas = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, PolygonOverlay> chunkOverlays = new HashMap<DimChunkPos, PolygonOverlay>();
    private List<OreDistanceInfo> oreDistanceInfos = new ArrayList<OreDistanceInfo>();
    private List<OreNearbyInfo> oreNearbyInfos = new ArrayList<OreNearbyInfo>();
    private final Minecraft mc = Minecraft.m_91087_();
    private boolean activated = true;

    public void setApi(IClientAPI api) {
        this.api = api;
    }

    public void onMappingStarted() {
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        if (veins.exists()) {
            RecipeManager mngr = Minecraft.m_91087_().m_91403_().m_105141_();
            try (FileReader rd = new FileReader(veins);){
                Map root = (Map)gson.fromJson((Reader)rd, Object.class);
                root.getOrDefault("veins", Collections.emptyList()).forEach(dimMap -> {
                    ResourceLocation dimKey = new ResourceLocation((String)dimMap.get("dim"));
                    ResourceKey lvl = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimKey);
                    dimMap.getOrDefault("veins", Collections.emptyList()).forEach(vein -> {
                        int x = ((Number)vein.get("x")).intValue();
                        int z = ((Number)vein.get("z")).intValue();
                        ResourceLocation key = new ResourceLocation((String)vein.get("id"));
                        VeinRecipe v = mngr.m_44043_(key).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
                        if (v != null) {
                            DimChunkPos p = new DimChunkPos((ResourceKey<Level>)lvl, x, z);
                            this.chunkDataLegacy.put(p, new OreVeinInfo(p, v, true));
                        }
                    });
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chunkDataLegacy.forEach((k, data) -> {
            if (!k.dimension.equals((Object)level.m_46472_())) {
                return;
            }
            this.showOverlay((Displayable)data.getOverlay());
            this.chunkOverlays.put((DimChunkPos)k, data.getOverlay());
        });
    }

    public void showOverlay(Displayable overlay) {
        try {
            this.api.show(overlay);
        }
        catch (Throwable t) {
            CreateOreExcavation.LOGGER.error(String.valueOf(t));
        }
    }

    public void showOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(this::showOverlay);
    }

    public void removeOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(o -> this.api.remove(o));
    }

    public void onMappingStopped() {
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        modFolder.mkdirs();
        try {
            HashMap<ResourceLocation, List> dimMap = new HashMap<ResourceLocation, List>();
            this.chunkDataLegacy.forEach((k, v) -> {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("x", k.x);
                m.put("z", k.z);
                m.put("id", v.id.toString());
                dimMap.computeIfAbsent(k.dimension.m_135782_(), __ -> new ArrayList()).add(m);
            });
            HashMap root = new HashMap();
            ArrayList vs = new ArrayList();
            root.put("veins", vs);
            dimMap.forEach((k, v) -> {
                HashMap<String, Object> d = new HashMap<String, Object>();
                vs.add(d);
                d.put("dim", k.toString());
                d.put("veins", v);
            });
            try (PrintWriter w = new PrintWriter(veins);){
                gson.toJson(root, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.chunkDataLegacy.clear();
        this.chunkDataAtlas.clear();
        this.chunkOverlays.clear();
        this.oreDistanceInfos.clear();
        this.oreNearbyInfos.clear();
    }

    private void toggleOverlay() {
        if (this.isActivated()) {
            this.removeOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
        } else {
            this.showOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
        }
        this.activated = !this.isActivated();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void toggle(IThemeButton button) {
        this.toggleOverlay();
        button.setToggled(Boolean.valueOf(this.activated));
    }

    public void setVeinInfo(ChunkPos posIn, ResourceLocation id) {
        RecipeManager mngr;
        VeinRecipe vein;
        DimChunkPos pos = new DimChunkPos((Level)this.mc.f_91073_, posIn);
        if (this.chunkDataLegacy.containsKey(pos)) {
            PolygonOverlay ov = this.chunkOverlays.remove(pos);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov);
            }
        }
        if ((vein = (VeinRecipe)(mngr = Minecraft.m_91087_().m_91403_().m_105141_()).m_44043_(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null)) != null) {
            OreVeinInfo info = new OreVeinInfo(pos, vein, true);
            this.chunkDataLegacy.put(pos, info);
            if (this.activated) {
                this.showOverlay((Displayable)info.getOverlay());
            }
            this.chunkOverlays.put(pos, info.getOverlay());
        }
    }

    public void addVeinNearbyInfo(ChunkPos center, ResourceLocation id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.f_91073_.m_46467_();
        RecipeManager mngr = Minecraft.m_91087_().m_91403_().m_105141_();
        VeinRecipe vein = mngr.m_44043_(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
        if (vein != null) {
            OreNearbyInfo v = new OreNearbyInfo((ResourceKey<Level>)this.mc.f_91073_.m_46472_(), center, vein, time + 600L);
            this.oreNearbyInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void addVeinDistanceInfo(BlockPos center, int radius, ResourceLocation id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.f_91073_.m_46467_();
        RecipeManager mngr = Minecraft.m_91087_().m_91403_().m_105141_();
        VeinRecipe vein = mngr.m_44043_(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
        if (vein != null) {
            OreDistanceInfo v = new OreDistanceInfo((ResourceKey<Level>)this.mc.f_91073_.m_46472_(), center, radius, vein, time + 600L);
            this.oreDistanceInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void tick() {
        if (this.mc.f_91073_ == null) {
            return;
        }
        long time = this.mc.f_91073_.m_46467_();
        if (time % 20L == 0L && this.isActivated()) {
            ItemStack atlas = ItemStack.f_41583_;
            int c = this.mc.f_91074_.m_150109_().m_6643_();
            for (int i2 = 0; i2 < c; ++i2) {
                ItemStack is = this.mc.f_91074_.m_150109_().m_8020_(i2);
                if (is.m_41720_() != Registration.VEIN_ATLAS_ITEM.get()) continue;
                atlas = is;
                break;
            }
            HashSet<DimChunkPos> found = new HashSet<DimChunkPos>();
            if (!atlas.m_41619_() && atlas.m_41783_() != null) {
                ListTag veins = atlas.m_41783_().m_128437_("veins", 10);
                for (int i3 = 0; i3 < veins.size(); ++i3) {
                    CompoundTag v = veins.m_128728_(i3);
                    if (v.m_128471_("hide")) continue;
                    int x = v.m_128451_("x");
                    int z = v.m_128451_("z");
                    ResourceLocation vid = ResourceLocation.m_135820_((String)v.m_128461_("id"));
                    ResourceLocation dim = ResourceLocation.m_135820_((String)v.m_128461_("dim"));
                    if (!dim.equals((Object)this.mc.f_91073_.m_46472_().m_135782_())) continue;
                    DimChunkPos pos = new DimChunkPos((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim), x, z);
                    Object var15_15 = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(vid).orElse(null);
                    if (!(var15_15 instanceof VeinRecipe)) continue;
                    VeinRecipe vr = var15_15;
                    found.add(pos);
                    OreVeinInfo info = new OreVeinInfo(pos, vr, false);
                    if (this.chunkDataAtlas.containsKey(pos)) {
                        if (this.chunkDataAtlas.get(pos).equals(info)) continue;
                        PolygonOverlay ov = this.chunkOverlays.remove(pos);
                        if (this.activated && ov != null) {
                            this.api.remove((Displayable)ov);
                        }
                    }
                    this.chunkDataAtlas.put(pos, info);
                    if (this.activated) {
                        this.showOverlay((Displayable)info.getOverlay());
                    }
                    this.chunkOverlays.put(pos, info.getOverlay());
                    this.chunkDataLegacy.remove(pos);
                }
            }
            this.chunkDataAtlas.keySet().removeIf(e -> {
                if (!found.contains(e)) {
                    PolygonOverlay ov = this.chunkOverlays.remove(e);
                    if (this.activated && ov != null) {
                        this.api.remove((Displayable)ov);
                    }
                    return true;
                }
                return false;
            });
        }
        if (!this.oreDistanceInfos.isEmpty()) {
            this.oreDistanceInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
        if (!this.oreNearbyInfos.isEmpty()) {
            this.oreNearbyInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
    }

    public static void addOreInfoToMap(CompoundTag tag) {
        ResourceLocation id;
        int x = tag.m_128451_("x");
        int z = tag.m_128451_("z");
        BlockPos pos = new BlockPos(x, 0, z);
        ChunkPos center = new ChunkPos(pos);
        if (tag.m_128441_("found")) {
            id = ResourceLocation.m_135820_((String)tag.m_128461_("found"));
            INSTANCE.setVeinInfo(center, id);
        }
        if (tag.m_128441_("nearby")) {
            id = ResourceLocation.m_135820_((String)tag.m_128461_("nearby"));
            INSTANCE.addVeinNearbyInfo(center, id);
        }
        if (tag.m_128441_("far")) {
            id = ResourceLocation.m_135820_((String)tag.m_128461_("far"));
            int dist = tag.m_128451_("dist");
            INSTANCE.addVeinDistanceInfo(pos, dist, id);
        }
    }

    static {
        gson = new GsonBuilder().create();
    }
}

