/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.NumberFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IModIngredientRegistration;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VeinIngredient
implements IIngredientHelper<VeinRecipe>,
IIngredientRenderer<VeinRecipe> {
    public static final IIngredientType<VeinRecipe> VEIN = () -> VeinRecipe.class;
    private ItemStack drill;

    public VeinIngredient(IModIngredientRegistration registration) {
        RecipeManager mngr = Minecraft.m_91087_().m_91403_().m_105141_();
        registration.register(VEIN, (Collection)mngr.m_44013_(CreateOreExcavation.VEIN_RECIPES.getRecipeType()), (IIngredientHelper)this, (IIngredientRenderer)this);
        this.drill = new ItemStack((ItemLike)Registration.NORMAL_DRILL_ITEM.get());
    }

    public void render(GuiGraphics guiGraphics, VeinRecipe ingredient) {
        RenderSystem.enableDepthTest();
        guiGraphics.m_280168_().m_85836_();
        GuiGameElement.of((ItemStack)ingredient.icon).render(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        float s = 0.5f;
        guiGraphics.m_280168_().m_252880_(8.0f, 8.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(s, s, s);
        GuiGameElement.of((ItemStack)this.drill).render(guiGraphics);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85849_();
    }

    public List<Component> getTooltip(VeinRecipe ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(ingredient.veinName);
        if (ingredient.isInfiniteClient()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.coe.infiniteVeins"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.coe.finiteVeins", (Object[])new Object[]{NumberFormatter.formatNumber(ingredient.getMinAmountClient()), NumberFormatter.formatNumber(ingredient.getMaxAmountClient())}));
        }
        return tooltip;
    }

    public IIngredientType<VeinRecipe> getIngredientType() {
        return VEIN;
    }

    public String getDisplayName(VeinRecipe ingredient) {
        return ingredient.veinName.getString();
    }

    public String getUniqueId(VeinRecipe ingredient, UidContext context) {
        return ingredient.m_6423_().toString();
    }

    public ResourceLocation getResourceLocation(VeinRecipe ingredient) {
        return ingredient.m_6423_();
    }

    public VeinRecipe copyIngredient(VeinRecipe ingredient) {
        return ingredient;
    }

    public String getErrorInfo(@Nullable VeinRecipe ingredient) {
        return ingredient != null && ingredient.id != null ? ingredient.id.toString() : "null";
    }
}

