/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.JeiPlatform;
import com.tom.createores.jei.VeinIngredient;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.VeinRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;

public abstract class ExcavatingCategory<T extends ExcavatingRecipe>
implements IRecipeCategory<T> {
    protected AnimatedBlock block;
    protected IDrawable background = new EmptyBackground(177, 100);
    protected IDrawable icon;

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        RecipeManager mngr = Minecraft.m_91087_().m_91403_().m_105141_();
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(((ExcavatingRecipe)recipe).getDrill());
        mngr.m_44043_(((ExcavatingRecipe)recipe).veinId).ifPresent(rec -> {
            if (rec instanceof VeinRecipe) {
                VeinRecipe r = (VeinRecipe)rec;
                builder.addSlot(RecipeIngredientRole.CATALYST, 100, 3).addIngredient(VeinIngredient.VEIN, (Object)r);
            }
        });
        if (((ExcavatingRecipe)recipe).getDrillingFluid() != FluidIngredient.EMPTY) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 69, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(JeiPlatform.FLUID_STACK, JeiPlatform.wrapFluid(((ExcavatingRecipe)recipe).getDrillingFluid().getMatchingFluidStacks()))).setFluidRenderer((long)((ExcavatingRecipe)recipe).getDrillingFluid().getRequiredAmount(), false, 16, 16);
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.block.draw(stack, 48, 35);
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY > 25.0 && mouseY < 60.0) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.coe.processTime", (Object[])new Object[]{((ExcavatingRecipe)recipe).getTicks()}));
            boolean hasGoggles = GogglesItem.isWearingGoggles((Player)Minecraft.m_91087_().f_91074_);
            if (hasGoggles) {
                LangBuilder rpmUnit = CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0]);
                tooltip.add((Component)CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
                int impact = ((ExcavatingRecipe)recipe).getStress();
                IRotate.StressImpact impactId = IRotate.StressImpact.HIGH;
                LangBuilder builder = CreateLang.builder().add(CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)(impactId.ordinal() + 1))).style(impactId.getAbsoluteColor()));
                tooltip.add((Component)builder.add(CreateLang.number((double)impact)).text("x ").add(rpmUnit).component());
            }
        }
        return tooltip;
    }
}

