/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.forge;

import com.robocraft999.creategoggles.CGConfig;
import com.robocraft999.creategoggles.CreateGoggles;
import com.robocraft999.creategoggles.forge.compat.curios.CompatCurios;
import com.robocraft999.creategoggles.forge.compat.mekanism.CompatMekanism;
import com.robocraft999.creategoggles.forge.data.RecipeDataProvider;
import com.robocraft999.creategoggles.forge.registry.CGItemsForge;
import com.robocraft999.creategoggles.forge.registry.CGModules;
import com.robocraft999.creategoggles.registry.ModCompat;
import dev.architectury.platform.forge.EventBuses;
import mekanism.api.MekanismIMC;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="creategoggles")
public class CreateGogglesForge {
    public static final Logger logger = LogManager.getLogger((String)"creategoggles");

    public CreateGogglesForge() {
        EventBuses.registerModEventBus((String)"creategoggles", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        CreateGoggles.REGISTRATE.defaultCreativeTab(CreativeModeTabs.f_256797_);
        CreateGoggles.init();
        CreateGoggles.LOGGER.info("CreateGogglesForge init");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CreateGoggles.REGISTRATE.registerEventListeners(modEventBus);
        if (ModCompat.MEKANISM.isLoaded()) {
            CGItemsForge.register();
            CGModules.register(modEventBus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CGConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CGConfig.clientSpec);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientRegistries);
        modEventBus.addListener(this::gatherData);
        ModCompat.MEKANISM.executeIfInstalled(() -> CompatMekanism::init);
        ModCompat.CURIOS.executeIfInstalled(() -> CompatCurios::init);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        logger.info("Create Goggles Setup");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        logger.info("Create Goggles Client Setup");
    }

    private void gatherData(GatherDataEvent event) {
        logger.info("gathering data");
        event.getGenerator().addProvider(true, (DataProvider)new RecipeDataProvider(event.getGenerator()));
    }

    @Mod.EventBusSubscriber(modid="creategoggles", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            if (ModCompat.CURIOS.isLoaded()) {
                // empty if block
            }
            if (ModCompat.MEKANISM.isLoaded()) {
                MekanismIMC.addMekaSuitHelmetModules((IModuleDataProvider[])new IModuleDataProvider[]{CGModules.GOGGLE_MODULE});
            }
        }
    }
}

