/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.pumpjack;

import com.jesz.createdieselgenerators.content.concrete.ConcreteEncasedFluidPipeBlock;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PumpjackHoleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    BlockState state;
    SmartFluidTankBehaviour tank;
    public int headPos = 0;
    public int bearingPos = 0;
    public boolean started = false;
    public int oilAmount = 0;
    byte tick = 0;
    public int pipeLength = 0;
    boolean valid = false;

    public PumpjackHoleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = state;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("OilAmount", this.oilAmount);
        compound.m_128379_("Started", this.started);
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.valid) {
            return false;
        }
        Lang.builder((String)"createdieselgenerators").translate("hint.pumpjack_hole_no_pipe.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        MutableComponent hint = Lang.builder((String)"createdieselgenerators").translate("hint.pumpjack_hole_no_pipe", new Object[0]).component();
        List cutComponent = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
        for (Component component : cutComponent) {
            CreateLang.builder().add(component).forGoggles(tooltip);
        }
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.valid || !this.started) {
            return false;
        }
        if (this.oilAmount == Integer.MAX_VALUE) {
            TooltipHelper.addHint(tooltip, (String)"hint.hose_pulley", (Object[])new Object[0]);
            return true;
        }
        CreateLang.builder().add(Component.m_237115_((String)"createdieselgenerators.goggle.oil_amount")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.text((String)String.format("%,d", this.oilAmount)).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.GOLD).forGoggles(tooltip);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.oilAmount = compound.m_128451_("OilAmount");
        this.started = compound.m_128471_("Started");
    }

    public void handleUpdateTag(CompoundTag compound) {
        super.handleUpdateTag(compound);
        this.oilAmount = compound.m_128451_("OilAmount");
        this.started = compound.m_128471_("Started");
    }

    public void tick() {
        super.tick();
        this.tick = (byte)(this.tick + 1);
        if (this.tick >= 20) {
            int pipeLength = 0;
            this.tick = 0;
            boolean valid = false;
            for (int i = 0; i < this.m_58899_().m_123342_() - this.f_58857_.m_141937_(); ++i) {
                ++pipeLength;
                BlockState bs = this.f_58857_.m_8055_(this.m_58899_().m_6625_(i + 1));
                if (bs.m_60734_() instanceof PipeBlock || bs.m_60734_() instanceof EncasedPipeBlock || bs.m_60734_() instanceof ConcreteEncasedFluidPipeBlock) {
                    if (((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue() && ((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61367_)).booleanValue()) continue;
                    break;
                }
                if (bs.m_60734_() instanceof GlassFluidPipeBlock) {
                    if (bs.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y) continue;
                    break;
                }
                if (bs.m_204336_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)new ResourceLocation("createdieselgenerators:pumpjack_pipe")))) continue;
                if (!bs.m_204336_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)new ResourceLocation("createdieselgenerators:oil_deposit")))) break;
                valid = true;
                break;
            }
            this.pipeLength = valid ? pipeLength : 0;
            this.valid = valid;
        }
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_((double)this.pipeLength);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        compound.m_128405_("OilAmount", this.oilAmount);
        compound.m_128379_("Started", this.started);
        return compound;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)8000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void pumpjackRotation(boolean isCrankLarge) {
        List stackList = ForgeRegistries.FLUIDS.tags().getTag(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:pumpjack_output"))).stream().distinct().toList();
        if (stackList.isEmpty()) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.valid) {
            ChunkPos chunkPos = new ChunkPos(this.m_58899_());
            this.oilAmount = OilChunksSavedData.getChunkOilAmount((ServerLevel)this.f_58857_, chunkPos);
            this.started = true;
            int subtractedAmount = Mth.m_14045_((int)((int)(1000.0f * Math.abs((float)this.headPos / (float)this.bearingPos)) * (isCrankLarge ? 2 : 1)), (int)0, (int)this.oilAmount);
            FluidStack oilStack = new FluidStack((Fluid)stackList.get(0), subtractedAmount);
            subtractedAmount = this.tank.getPrimaryHandler().fill(oilStack, IFluidHandler.FluidAction.EXECUTE);
            if (this.oilAmount == Integer.MAX_VALUE) {
                return;
            }
            this.oilAmount -= subtractedAmount;
            OilChunksSavedData.setChunkOilAmount((ServerLevel)this.f_58857_, chunkPos, this.oilAmount);
        }
        if (this.f_58857_.f_46443_ && this.oilAmount > 0) {
            FluidFX.spawnPouringLiquid((Level)this.f_58857_, (BlockPos)this.f_58858_, (int)20, (ParticleOptions)FluidFX.getFluidParticle((FluidStack)new FluidStack((Fluid)stackList.get(0), 1000)), (float)0.3f, (Vec3)new Vec3(0.1, 1.0, 0.1), (boolean)true);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER) {
            return super.getCapability(cap, side);
        }
        if (side == Direction.NORTH && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.EAST && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.SOUTH && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.WEST && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

